﻿Imports NetShopForge.Library.Product
Imports NetShopForge.Library.Category
Partial Class Admin_Controls_ChooseProductsControl
    Inherits System.Web.UI.UserControl

    Public Event ProductSelected(ByVal selectedProducts As Generic.List(Of ProductSelectedInfo))

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not IsPostBack Then
            hfSearchText.Value = ""
            CategoryTree.Instance.SetCategoryList(ddlCategory, "全部类别")
            btnSelect.Visible = False
            gvProduct.Visible = False
        End If
    End Sub

    Private Sub BindData()

        Dim totalRecords As Integer = 0
        Dim SearchText As String = hfSearchText.Value

        Dim producList As Generic.List(Of ProductInfo)
        Dim sqlWhere As String = ""
        If SearchText.Trim().Length <> 0 Then
            SearchText = SearchText.Replace("*", "%")
            SearchText = SearchText.Replace("?", "_")
            sqlWhere = String.Format("LOWER({1}) LIKE '{0}'", SearchText.ToLower.Replace("'", "''"), ddlSearch.SelectedValue)
        End If

        If ddlCategory.SelectedValue = -1 Then
            producList = ProductController.GetProductList(Pager.PageSize, Pager.CurrentPageIndex, totalRecords, sqlWhere)
        Else
            producList = ProductController.GetProductList(Pager.PageSize, Pager.CurrentPageIndex, totalRecords, CInt(ddlCategory.SelectedValue), sqlWhere)
        End If

        Pager.RecordCount = totalRecords
        btnSelect.Visible = (totalRecords > 0)
        gvProduct.DataSource = producList
        gvProduct.DataBind()
        Pager.CustomInfoHTML = "记录总数:" + Pager.RecordCount.ToString()
        Pager.CustomInfoHTML += " 总页数:" + Pager.PageCount.ToString()
        Pager.CustomInfoHTML += " 当前页:" + Pager.CurrentPageIndex.ToString()
    End Sub

    Protected Sub ChangePage(ByVal src As Object, ByVal e As EventArgs) Handles Pager.PageChanged
        ' Dim startTime As System.DateTime = System.DateTime.Now

        BindData()
        'Dim endTime As System.DateTime = System.DateTime.Now
        'Dim ts As System.TimeSpan = endTime - startTime
        ''   Label1.Text = "页面执行时间:" & ts.Milliseconds & " 毫秒"
    End Sub

    Protected Sub btnSearch_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnSearch.Click
        hfSearchText.Value = txtSearch.Text
        If hfSearchText.Value = "输入查询关键字" Then hfSearchText.Value = ""
        Pager.CurrentPageIndex = 1
        BindData()
        txtSearch.Text = ""
        gvProduct.Visible = True
    End Sub


    Protected Sub btnSelect_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnSelect.Click
        'Dim objPBC As New ProductBookmarkController
        Dim objPSList As Generic.List(Of ProductSelectedInfo) = New Generic.List(Of ProductSelectedInfo)
        For i As Integer = 0 To gvProduct.Rows.Count - 1
            If gvProduct.Rows(i).RowType = DataControlRowType.DataRow Then
                Dim cbSelect As CheckBox = CType(gvProduct.Rows(i).FindControl("cbSelect"), CheckBox)
                Dim lbProductName As Label = CType(gvProduct.Rows(i).FindControl("lbProductName"), Label)
                Dim lbPrice As Label = CType(gvProduct.Rows(i).FindControl("lbPrice"), Label)
                Dim ps As New ProductSelectedInfo
                ps.Price = lbPrice.Text
                ps.ProductID = gvProduct.DataKeys(i).Value
                ps.productName = lbProductName.Text
                If cbSelect.Checked Then
                    objPSList.Add(ps)
                    cbSelect.Checked = False
                End If
            End If
        Next i



        RaiseEvent ProductSelected(objPSList)
     
        Pager.Visible =False 
        btnSelect.Visible = false
        gvProduct.Visible = False
     

    End Sub
End Class
