﻿Imports AspNetSecurity = System.Web.Security
Partial Class Admin_Management_Controls_AddUserControl
    Inherits System.Web.UI.UserControl

    Protected Sub btnSave_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnSave.Click


        Dim createStatus As MembershipCreateStatus = MembershipCreateStatus.Success
        Dim resultMsg As String = ""

        Dim userIDText As String = UserName.Text
        Dim emailText As String = Email.Text
        Dim isActive As Boolean = CBool(ddlIsApproved.SelectedValue)
        Dim _password As String = Password.Text

 

        Try
            Dim mu As MembershipUser = Nothing

            mu = Membership.CreateUser(userIDText, _password, emailText)
  
            If createStatus = MembershipCreateStatus.Success AndAlso (Not mu Is Nothing AndAlso (Not String.IsNullOrEmpty(mu.UserName))) Then
                AddRoleMembership(mu.UserName)
                Dim IsApproved As Boolean = CBool(ddlIsApproved.SelectedValue)
                If Not IsApproved Then
                    mu.IsApproved = False
                    Membership.UpdateUser(mu)
                End If
            
            End If
            Dim URL As String = String.Format("Users.aspx?mode=edituser&username={0}", mu.UserName)
            ResultMessageControl1.ShowSuccess(String.Format("成功创建的帐户。<a href =""{0}"">管理用户({1})</a>", URL, mu.UserName))
            Response.Redirect(URL)
        Catch ex As Exception
            ResultMessageControl1.ShowFail("创建帐户失败。请重试。 失败原因: " & ex.Message)
        End Try

    End Sub


    Private Sub AddRoleMembership(ByVal userName As String)
        If String.IsNullOrEmpty(userName) Then
            Return
        End If

        Dim role As String = ddlUserType.SelectedValue
        Roles.AddUserToRole(userName, role)

    End Sub

End Class
