Imports NetShopForge.Library.Product

Partial Class Admin_Management_Controls_AttributeTemplateControl
    Inherits System.Web.UI.UserControl


#Region "-------EvemtArgs Method---------"

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load

        If Not IsPostBack Then
            BindSelections(Nothing)
            BindAttList()
        End If
    End Sub

    Protected Sub btnAddSection_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnAddSection.Click


        'create an attribute list
        Dim aList As ArrayList = GetSelections()
        If aList Is Nothing Then
            aList = New ArrayList()
        End If

        'create a new selection and add it
        Dim sel As ProductAttributeSelection = New ProductAttributeSelection()

        sel.Value = txtSelectionAdd.Text
        sel.ItemOrder = aList.Count * 10

        aList.Add(sel)
        aList.Sort()
        BindSelections(aList)

        txtSelectionAdd.Text = ""

    End Sub

    Protected Sub btnAddAttribute_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnAddAttribute.Click


        Dim att As New ProductAttributeInfo
        Dim atts As New ProductAttributeCollection
        Dim attributeTemplate As New ProductAttributeTemplateInfo
        attributeTemplate.ProductAttributeID = CInt(hfAttributeTemplateID.Value)
        attributeTemplate.AttributeName = txtAttributeNew.Text.Trim()
        attributeTemplate.AttributeType = Integer.Parse(ddlAttNewSelectionType.SelectedValue)
        Dim aList As ArrayList = GetSelections()
        If Not aList Is Nothing Then
            If aList.Count > 0 Then
                att.Selections = New System.Collections.Generic.List(Of ProductAttributeSelection)
                Dim i As Integer = 0
                Do While i < aList.Count
                    att.Selections.Add(CType(aList(i), ProductAttributeSelection))
                    i += 1
                Loop
            End If
        End If
        atts.Add(att)
        attributeTemplate.SelectionList = atts.ToXML
        attributeTemplate.Description = txtAttNewDesc.Text.Trim()
        Dim objATC As New ProductAttributeTemplateController



        If hfAttributeTemplateID.Value = "-1" Then
            txtAttNewDesc.Text = ""
            txtAttributeNew.Text = ""
            ddlAttNewSelectionType.SelectedIndex = 0
            ViewState.Remove("aList")
            BindSelections(Nothing)
            objATC.AddProductAttributeTemplate(attributeTemplate)
        Else
            objATC.UpdateProductAttributeTemplate(attributeTemplate)
        End If

        BindAttList()

    End Sub


    Protected Sub gvAttributes_RowEditing(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.GridViewEditEventArgs) Handles gvAttributes.RowEditing

        Dim atc As New ProductAttributeTemplateController
        hfAttributeTemplateID.Value = gvAttributes.DataKeys(e.NewEditIndex).Value
        Dim template As ProductAttributeTemplateInfo = atc.GetProductAttributeTemplate(hfAttributeTemplateID.Value)

        txtAttributeNew.Text = template.AttributeName
        txtAttNewDesc.Text = template.Description
        ddlAttNewSelectionType.SelectedValue = CInt(template.AttributeType)
        Dim attributes As ProductAttributeCollection = CType(NetShopForge.Common.Utility.XmlToObject(GetType(ProductAttributeCollection), template.SelectionList), ProductAttributeCollection)
        Dim AttributeInfo As ProductAttributeInfo = attributes.Item(0)

        Dim aList As New ArrayList
        'create a new selection and add it
        If Not IsNothing(AttributeInfo.Selections) Then
            For Each sel As ProductAttributeSelection In AttributeInfo.Selections
                aList.Add(sel)
            Next
        End If
        BindSelections(aList)

        btnAddAttribute.Text = ""
        btnClose.Visible = True

    End Sub

    Protected Sub btnUpdateSection_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnUpdateSection.Click

        Dim aList As New ArrayList
        For Each row As GridViewRow In gvSections.Rows

            Dim txtSelection As TextBox = CType(row.Cells(1).FindControl("txtSelection"), TextBox)
            Dim txtItemOrder As TextBox = CType(row.Cells(2).FindControl("txtItemOrder"), TextBox)
            Dim sel As New ProductAttributeSelection
            sel.Value = txtSelection.Text
            sel.ItemOrder = txtItemOrder.Text
            aList.Add(sel)
            aList.Sort()
        Next row
        BindSelections(aList)

    End Sub

    Protected Sub btnDeleteSection_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnDeleteSection.Click

        Dim aList As ArrayList = GetSelections()
        Dim c As New Collection

        For Each row As GridViewRow In gvSections.Rows

            Dim cbSelect As CheckBox = CType(row.Cells(0).FindControl("cbSelect"), CheckBox)
            If cbSelect.Checked Then
                If Not aList Is Nothing Then
                    c.Add(CType(aList(row.RowIndex), ProductAttributeSelection))
                End If
            End If

        Next row

        For i As Integer = 1 To c.Count
            aList.Remove(CType(c.Item(i), ProductAttributeSelection))
        Next i
        BindSelections(aList)

    End Sub

    Protected Sub btnDeleteAttribute_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnDeleteAttribute.Click
        Dim atc As New ProductAttributeTemplateController
        For Each row As GridViewRow In gvAttributes.Rows
            Dim cbSelect As CheckBox = CType(row.Cells(0).FindControl("cbSelect"), CheckBox)
            If cbSelect.Checked Then

                atc.DeleteProductAttributeTemplate(gvAttributes.DataKeys(row.RowIndex).Value)

            End If
        Next
        BindAttList()

    End Sub

    Protected Sub btnClose_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnClose.Click
        txtAttNewDesc.Text = ""
        txtAttributeNew.Text = ""
        ddlAttNewSelectionType.SelectedIndex = 0

        ViewState.Remove("aList")
        BindSelections(Nothing)
        btnClose.Visible = False
        btnAddAttribute.Text = "µѡ"
        hfAttributeTemplateID.Value = "-1"
    End Sub

#End Region

#Region "---Private Method----"

    Private Sub BindAttList()
        Dim atc As New ProductAttributeTemplateController
        Dim AttributeTemplates As Generic.List(Of ProductAttributeTemplateInfo) = atc.GetProductAttributeTemplateList
        gvAttributes.DataSource = AttributeTemplates
        gvAttributes.DataBind()
        Dim b As Boolean = gvAttributes.Rows.Count > 0
        btnDeleteAttribute.Visible = b

    End Sub

    Private Function GetSelections() As ArrayList
        Dim aList As ArrayList = Nothing
        If Not ViewState("aList") Is Nothing Then
            aList = CType(ViewState("aList"), ArrayList)
        End If
        Return aList
    End Function


    Private Sub BindSelections(ByVal aList As ArrayList)

        ViewState("aList") = aList

        gvSections.DataSource = aList
        gvSections.DataBind()
        Dim b As Boolean = gvSections.Rows.Count > 0
        btnUpdateSection.Visible = b
        btnDeleteSection.Visible = b
    End Sub

#End Region


End Class
