Imports NetShopForge.Library.Brand

Partial Class Admin_Management_Controls_BrandControl
    Inherits System.Web.UI.UserControl

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load

        If Not IsPostBack Then
            BindData()
        End If

    End Sub

    Private Sub BindData()
        Dim objMC As New BrandController

        gvBrand.DataSource = objMC.GetBrandList()
        gvBrand.DataBind()


        Dim b As Boolean = (gvBrand.Rows.Count > 0)
        btn_Brand_Delete.Visible = b
        btn_Brand_Update.Visible = b
    End Sub

    Protected Sub btn_Brand_AddNew_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btn_Brand_AddNew.Click
        My.Response.Redirect("~/Admin/Management/Brand.aspx?mode=editBrand&action=addnew")
    End Sub

    Protected Sub btn_Brand_Delete_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btn_Brand_Delete.Click
        Try
            Dim objBC As New BrandController
            For i As Integer = 0 To gvBrand.Rows.Count - 1
                If gvBrand.Rows(i).RowType = DataControlRowType.DataRow Then
                    Dim cbSelect As CheckBox = CType(gvBrand.Rows(i).FindControl("cbSelect"), CheckBox)
                    If cbSelect.Checked Then objBC.DeleteBrand(CInt(gvBrand.DataKeys(i).Value))
                End If

            Next i
            BindData()
            ResultMessageControl1.ShowSuccess("ɾɹ")
        Catch ex As Exception
            ResultMessageControl1.ShowFail("ɾʧܣ" & ex.Message)
        End Try
 
    End Sub

    Protected Sub btn_Brand_Update_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btn_Brand_Update.Click

        Try
            Dim objBC As New BrandController
            For i As Integer = 0 To gvBrand.Rows.Count - 1
                If gvBrand.Rows(i).RowType = DataControlRowType.DataRow Then
                    Dim txtItemOrder As TextBox = CType(gvBrand.Rows(i).FindControl("txtItemOrder"), TextBox)
                    Dim ddlIsValid As DropDownList = CType(gvBrand.Rows(i).FindControl("ddlIsValid"), DropDownList)
                    Dim BrandID As Integer = CInt(gvBrand.DataKeys(i).Value)

                    objBC.UpdateBrandQuick(BrandID, txtItemOrder.Text, CInt(ddlIsValid.SelectedValue))
                End If

            Next i
            BindData()
            ResultMessageControl1.ShowSuccess("³ɹ")
        Catch ex As Exception
            ResultMessageControl1.ShowFail("ʧܣ" & ex.Message)
        End Try
 

    End Sub
End Class
