#Region "Imports"
Imports NetShopForge.Library.Category
Imports NetShopForge.Library.Product
#End Region

Partial Class Admin_Management_Controls_CategoryListControl
    Inherits System.Web.UI.UserControl

#Region "---Event Method---"

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load

        If Not IsPostBack Then
            Dim catID As Integer = Request("CatID")
            If catID = 0 Then catID = -1
            hfCatID.Value = catID.ToString
            BindData(catID)
        End If
    End Sub
    Protected Sub btnUpdate_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnUpdate.Click
        Try
            For i As Integer = 0 To gvCategory.Rows.Count - 1
                If gvCategory.Rows(i).RowType = DataControlRowType.DataRow Then
                    Dim ddlIsVaild As DropDownList = CType(gvCategory.Rows(i).FindControl("ddlIsValid"), DropDownList)
                    Dim txtItemOrder As TextBox = CType(gvCategory.Rows(i).FindControl("txtItemOrder"), TextBox)
                    CategoryController.Instance.UpdateCategoryQuick(CInt(gvCategory.DataKeys(i).Value), GetPostionCategory(txtItemOrder.Text), CBool(ddlIsVaild.SelectedValue))
                End If
            Next

            BindData(CInt(hfCatID.Value))
            System.Web.HttpContext.Current.Cache.Remove("CategoryTable")
            ResultMessageControl1.ShowSuccess("³ɹ")
        Catch ex As Exception

            ResultMessageControl1.ShowFail("ʧܣ" & Environment.NewLine & ex.Message)
        End Try
   
    End Sub

    Protected Sub gvCategory_PageIndexChanging(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.GridViewPageEventArgs) Handles gvCategory.PageIndexChanging
        gvCategory.PageIndex = e.NewPageIndex
        Dim catID As Integer = hfCatID.Value
        BindData(catID)
    End Sub

    Protected Sub gvCategory_RowDataBound(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.GridViewRowEventArgs) Handles gvCategory.RowDataBound

        If e.Row.RowType = DataControlRowType.DataRow Then

            Dim hlProduct As HyperLink = CType(e.Row.Cells(4).FindControl("hlProduct"), HyperLink)
            Dim hlSubCategory As HyperLink = CType(e.Row.Cells(4).FindControl("hlSubCategory"), HyperLink)
            Dim catID As Integer = CInt(gvCategory.DataKeys(e.Row.RowIndex).Value)
            Dim NProduct As Integer = CategoryController.GetNProductbyCategory(catID)
            Dim NSubCat As Integer = CategoryController.GetNSubCatbyCategory(catID)
            hlProduct.Text = IIf(NProduct = 0, "", NProduct.ToString)
            hlSubCategory.Text = IIf(NSubCat = 0, "", NSubCat.ToString)
        End If
    End Sub

    Protected Sub gvCategory_RowDeleting(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.GridViewDeleteEventArgs) Handles gvCategory.RowDeleting
        Try

            Dim categoryID As Integer = CInt(gvCategory.DataKeys(e.RowIndex).Value)
            Dim objcc As New CategoryController
            CategoryController.Instance.DeleteCategory(categoryID)
            BindData(CInt(hfCatID.Value))
            System.Web.HttpContext.Current.Cache.Remove("CategoryTable")
            ResultMessageControl1.ShowSuccess("ɾɹ")
        Catch ex As Exception

            ResultMessageControl1.ShowFail("ɾʧܣ" & Environment.NewLine & ex.Message)
        End Try

    End Sub

    Protected Sub btnAddNew_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnAddNew.Click
        Dim RedirectURL As String = String.Format("~/Admin/Management/Categories.aspx?mode=editcategory&catID={0}&action=addnew", hfCatID.Value)
        My.Response.Redirect(RedirectURL)
    End Sub
    Protected Sub btnEdit_Click(ByVal sender As Object, ByVal e As System.EventArgs)
        My.Response.Redirect(String.Format("~/Admin/Management/Categories.aspx?mode=editcategory&catID={0}&action=edit", CType(sender, Button).CommandArgument))
    End Sub

#End Region

#Region "----Private Method---"

    Private Sub BindData(ByVal categoryFateherID As Integer)

        gvCategory.DataSource = CategoryController.GetCategoryList(categoryFateherID)
        gvCategory.DataBind()

        Dim b As Boolean = (gvCategory.Rows.Count > 0)
        btnUpdate.Visible = b

        If categoryFateherID = -1 Then
            CategoryMapPath.Text = ""
        Else
            Dim objCI As CategoryInfo = CategoryController.GetCategory(categoryFateherID)
            CategoryMapPath.Text = CategoryController.GetCategoryMapPath(categoryFateherID, False)
        End If

    End Sub

    Private Function GetPostionCategory(ByVal pos As String) As Integer
        If Not IsNumeric(pos) Then
            Dim i As Integer = gvCategory.Rows.Count
            If i = 0 Then
                Return 0
            Else
                Dim txtItemOrder As TextBox = CType(gvCategory.Rows(i - 1).FindControl("txtItemOrder"), TextBox)
                If Not IsNumeric(txtItemOrder.Text) Then Return 0
                Return CInt(txtItemOrder.Text) + 10
            End If
        Else
            Return CInt(pos)
        End If
    End Function

#End Region





End Class
