
Imports NetShopForge.Library.Brand
Imports NetShopForge.Common
Imports NetShopForge.Common.nsfImage
Imports System.IO




Partial Class Admin_Management_Controls_EditBrandControl
    Inherits System.Web.UI.UserControl


    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load

        If Not IsPostBack Then

            Dim BrandID As Integer = Request("BrandID")
            Dim action As String = Request("action")
            If BrandID = 0 Then BrandID = -1
            hfBrandID.Value = BrandID
            hfAction.Value = action
            If IsNothing(hfAction.Value) Then hfAction.Value = "addnew"
            BindData(hfBrandID.Value)

        End If

    End Sub

    Private Sub BindData(ByVal BrandID As Integer)

        Dim objMC As New BrandController
        Dim objBrand As BrandInfo = Nothing
        If BrandID > 0 Then
            objBrand = objMC.GetBrand(BrandID)
            If Not IsNothing(objBrand) Then
                lblDialogTitle.Text = "༭Ʒ"
                txtDescription.Text = objBrand.Description
                txtBrand.Text = objBrand.Brand
                txtManufacturers.Text = objBrand.Manufacturer
                txtItemOrder.Text = objBrand.ItemOrder
                txtURL.Text = objBrand.URL

                ddlIsValid.SelectedValue = CInt(objBrand.IsValid)
                ImagePickerControl1.SetImage(objBrand.LogoPath)
            End If
        Else
            lblDialogTitle.Text = "Ʒ"
            '  hlICON.ImageUrl = String.Format("~/IHttpHandler/ImageHandler.ashx?Imagepath=~/{0}&Size={1}", "", "120,120")
        End If

    End Sub

    'Protected Sub btnUploadICON_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnUploadICON.Click
    '    'DeleteDir(Server.MapPath("~\" & tempProductImagePath))
    '    Dim FileName As String = "c_" & Session.SessionID

    '    Dim objIC As New ImageController
    '    Dim sOK As String = objIC.UploadImage(FileUploadThumb.PostedFile, tempBrandImagePath, FileName)
    '    hfImageFileName.Value = String.Format("{0}/{1}", tempBrandImagePath.Replace("\", "/"), FileName & Path.GetExtension(FileUploadThumb.PostedFile.FileName).ToLower)
    '    '  hlICON.ImageUrl = String.Format("~/IHttpHandler/ImageHandler.ashx?Imagepath=~/{0}&size=100,100", hfImageFileName.Value)
    '    If sOK.Length > 0 Then
    '        ResultMessageControl1.ShowFail(sOK)
    '    End If
    'End Sub

    'Protected Sub DeleteICON_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles DeleteICON.Click
    '    '  hlICON.ImageUrl = ""
    '    hfImageFileName.Value = ""
    'End Sub

    Protected Sub btnSave_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnSave.Click

        Dim objBI As New BrandInfo
        objBI.Brand = txtBrand.Text
        objBI.LogoPath = ImagePickerControl1.GetSelectedImage
        objBI.Description = txtDescription.Text
        objBI.Manufacturer = txtManufacturers.Text
        objBI.IsValid = CBool(ddlIsValid.SelectedValue)
        If txtItemOrder.Text.Length = 0 Then
            objBI.ItemOrder = 0
        Else
            objBI.ItemOrder = IIf(IsNumeric(txtItemOrder.Text), CInt(txtItemOrder.Text), 0)
        End If
        objBI.URL = txtURL.Text

        Dim objBC As New BrandController
        Select Case hfAction.Value.ToLower
            Case "edit"
                objBI.BrandID = CInt(hfBrandID.Value)
                objBC.UpdateBrand(objBI)
                BindData(hfBrandID.Value)
            Case "addnew"
                objBI.BrandID = GetKeys("BrandID")
                objBI.BrandID = objBC.AddBrand(objBI)
                Response.Redirect(String.Format("~/Admin/Management/Brand.aspx?mode=editBrand&BrandID={0}&action=edit", objBI.BrandID))

        End Select
    End Sub



End Class
