Imports NetShopForge.Library.Category
Imports NetShopForge.Library.Product
Imports NetShopForge.Common
Imports NetShopForge.Common.nsfImage
Imports System.Data
Imports System.IO

Partial Class Admin_Management_Controls_EditCategoryControl
    Inherits System.Web.UI.UserControl

    Public Const tempCategoryImagePath As String = "Image_Shop\Category\temp"
    Public Const CategoryImagePath As String = "Image_Shop\Category"

#Region "---EventArg Method---"

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load

        If Not IsPostBack Then


            Dim catID As Integer = Request("CatID")
            Dim action As String = Request("action")
            If catID = 0 Then
                catID = -1
            Else
                Category.CategoryTree.Instance.SetCategoryList(ddlCategory, "")
            End If
            ddlCategory.SelectedValue = Category.CategoryController.GetCategoryFatherID(catID)
            hfCatID.Value = catID
            hfAction.Value = action
            BindData(catID, action)
        End If

    End Sub
    Protected Sub btnSave_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnSave.Click

        Dim objCI As New CategoryInfo
        objCI.CategoryName = txtCategoryName.Text
        objCI.ImagePath = "" ' CopyImage(hfCatID.Value.ToString)
        objCI.Description = txtDescription.Text
        objCI.IsValid = CBool(ddlIsValid.SelectedValue)
        If txtItemOrder.Text.Length = 0 Then
            objCI.ItemOrder = 0
        Else
            objCI.ItemOrder = IIf(IsNumeric(txtItemOrder.Text), CInt(txtItemOrder.Text), 0)
        End If
        objCI.CategoryFatherID = ddlCategory.SelectedValue
        objCI.MetaDescription = txtMetaDescription.Text
        objCI.MetaKeywords = txtMetaKeywords.Text
        System.Web.HttpContext.Current.Cache.Remove("CategoryTable")
        Try
            Select Case hfAction.Value.ToString.ToLower
                Case "edit"

                    objCI.ImagePath = "" ' CopyImage(hfCatID.Value.ToString)
                    objCI.CategoryID = hfCatID.Value
                    Dim fID As Integer = CInt(ddlCategory.SelectedValue)
                    If CategoryController.Instance.IsValidCategoryFatherID(fID, hfCatID.Value) Then
                        objCI.CategoryFatherID = fID
                        CategoryController.Instance.UpdateCategory(objCI)
                        BindData(objCI.CategoryID, hfAction.Value.ToString.ToLower)
                    Else
                        ResultMessageControl1.ShowFail("ϼԼ")
                        Exit Sub

                    End If
                    ResultMessageControl1.ShowSuccess("³ɹ")

                Case "addnew"

                    objCI.CategoryFatherID = ddlCategory.SelectedValue
                    objCI.CategoryID = CategoryController.Instance.AddCategory(objCI)
                    objCI.ImagePath = "" ' CopyImage(objCI.CategoryID.ToString)

                    Response.Redirect(String.Format("~/Admin/Management/Categories.aspx?mode=editcategory&catID={0}&action=edit", objCI.CategoryID.ToString))

            End Select
            HttpContext.Current.Cache.Remove("Treeview")

        Catch ex As Exception
            ResultMessageControl1.ShowSuccess("ʧܣ" & ex.Message)
        End Try
      
    End Sub
    'Protected Sub btnUploadICON_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnUploadICON.Click
    '    'DeleteDir(Server.MapPath("~\" & tempProductImagePath))
    '    Dim objImage As New UploadImageInfo
    '    objImage.ImageSavePath = tempCategoryImagePath
    '    objImage.FileName = "c_" & Session.SessionID
    '    Dim objIC As New ImageController
    '    lbThumbMessage.Text = objIC.UploadImage(FileUploadThumb.PostedFile, objImage)
    '    hfCatImageFileName.Value = String.Format("{0}/{1}", tempCategoryImagePath.Replace("\", "/"), objImage.FileName & Path.GetExtension(FileUploadThumb.PostedFile.FileName).ToLower)
    '    hlICON.ImageUrl = String.Format("~/IHttpHandler/ImageHandler.ashx?Imagepath=~/{0}&size=100,100", hfCatImageFileName.Value.ToString)
    'End Sub
    'Protected Sub DeleteICON_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles DeleteICON.Click
    '    hlICON.ImageUrl = "~/Image_Shop/Products/noimage.gif"
    '    hfCatImageFileName.Value = ""
    'End Sub

#End Region

#Region "---Private Method---"


    Private Sub BindData(ByVal categoryID As Integer, ByVal action As String)

        Dim objCI As New CategoryInfo

        CategoryMapPath.Text = CategoryController.GetCategoryMapPath(categoryID, False)
        If categoryID <> -1 Then
            objCI = CategoryController.GetCategory(categoryID)
        Else
            Exit Sub
        End If
        If IsNothing(action) Then action = "addnew"
        Select Case action.ToLower
            Case "edit"
                lblDialogTitle.Text = "༭"
                txtCategoryName.Text = objCI.CategoryName
                txtDescription.Text = objCI.Description
                txtMetaDescription.Text = objCI.MetaDescription
                txtMetaKeywords.Text = objCI.MetaKeywords
                ddlIsValid.SelectedValue = IIf(objCI.IsValid, -1, 0)
                ' CategoryListControl1.CategoryID = objCI.CategoryID
                '    hlICON.ImageUrl = String.Format("~/IHttpHandler/ImageHandler.ashx?Imagepath=~/{0}&size=100,100", objCI.ImagePath)

                ' hfCatImageFileName.Value = objCI.ImagePath
            Case "addnew"
                lblDialogTitle.Text = ""
                ' CategoryListControl1.CategoryID = objCI.CategoryID

        End Select

    End Sub

    'Private Function CopyImage(ByVal categoryID As Integer) As String

    '    Dim destFileName, sourceFileName As String
    '    If hfCatImageFileName.Value.ToString.IndexOf("temp") > -1 Then
    '        sourceFileName = HttpContext.Current.Request.PhysicalApplicationPath & hfCatImageFileName.Value
    '        Dim destPath As String = HttpContext.Current.Request.PhysicalApplicationPath & CategoryImagePath
    '        Dim destName As String = "C" & String.Format("{0:D5}", categoryID) & Path.GetExtension(sourceFileName).ToLower
    '        destFileName = destPath & "\" & destName

    '        If Not System.IO.Directory.Exists(destPath) Then System.IO.Directory.CreateDirectory(destPath)

    '        If File.Exists(destFileName) Then File.Delete(destFileName)
    '        If File.Exists(sourceFileName) Then File.Move(sourceFileName, destFileName)
    '        hfCatImageFileName.Value = CategoryImagePath & "\" & destName
    '    End If
    '    Return hfCatImageFileName.Value.ToString
    'End Function 'CopyMainImage
#End Region



End Class
