Imports System
Imports NetShopForge.Library.Feature
Imports System.Data


Partial Class Admin_Management_Controls_EditFeatureControl
    Inherits System.Web.UI.UserControl

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not IsPostBack Then
            hfFeatureGroupID.Value = Request("featureGroupID")

            If hfFeatureGroupID.Value.Length > 0 Then
                Dim fgID As Integer = CInt(hfFeatureGroupID.Value)
                If fgID = -1 Then
                    pFeatureOption.Visible = False
                Else
                    pFeatureOption.Visible = True
                    Binddata(fgID)
                End If

            End If


        End If
    End Sub
    Protected Sub btnSaveFeatureGroup_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnSaveFeatureGroup.Click
        pFeatureOption.Visible = True
    End Sub
    Protected Sub ddlSelectType_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles ddlSelectType.SelectedIndexChanged
        ddlDataType.Enabled = (ddlSelectType.SelectedValue = 0)
        pFeatureSelect.Visible = (ddlSelectType.SelectedValue <> 0)
    End Sub


#Region "---Privte Method---"


    Private Sub Binddata(ByVal featureGroupID As Integer)

        Dim objFC As New FeatureController
        Dim objFGI As FeatureGroupInfo = objFC.GetFeatureGroup(featureGroupID)
        txtName.Text = objFGI.FeatureGroupName
        txtDescription.Text = objFGI.Description
        txtItemOrder.Text = objFGI.ItemOrder
        ddlIsVaild.SelectedValue = IIf(objFGI.IsValid, -1, 0)


        gvFeatureItem.DataSource = objFC.GetFeatureItemList(featureGroupID)
        gvFeatureItem.DataBind()
        Dim b As Integer = gvFeatureItem.Rows.Count > 0
        btnUpdateOption.Visible = b
        btnDeleteOption.Visible = b

    End Sub

    Private Sub BindGridPFI()

        ' ''Dim objPFC As New FeatureController
        ' ''grdPFI.DataSource = objPFC.GetFeatureItemList(CInt(ViewState("keyID")))
        ' ''grdPFI.DataBind()
        '' '' If grdFeatrueGroup.Items.Count < grdFeatrueGroup.PageSize Then grdFeatrueGroup.PagerStyle.Visible = False
        ' ''If grdPFI.Items.Count = 0 Then
        ' ''    lblGridMessage.Text = "ûԳԱ!"
        ' ''    lblGridMessage.Visible = True
        ' ''End If

    End Sub
    Private Sub BindItemData(ByVal featureID As Integer)

        Dim objPFC As New FeatureController
        Dim objPFI As FeatureItemInfo = objPFC.GetProductFeatureItem(featureID)

        If IsNothing(objPFI) Then Exit Sub

        txtName.Text = objPFI.FeatureName
        txtDescription.Text = objPFI.Description
        txtItemOrder.Text = objPFI.ItemOrder
        ddlIsVaild.SelectedValue = CInt(objPFI.IsValid)
        ddlDataType.SelectedValue = objPFI.DataType
        ddlIsSearch.SelectedValue = CInt(objPFI.IsSearch)
        ddlSelectType.SelectedValue = objPFI.SelectType

        ddlDataType.Enabled = (ddlSelectType.SelectedValue = 0)
        pFeatureSelect.Visible = (ddlSelectType.SelectedValue <> 0)


        ''  ViewState("tempFStable") = objPFC.GetProductFeatureSelectList(featureID).Tables(0)
        grdPFS.DataSource = CType(ViewState("tempFStable"), DataTable)
        grdPFS.DataBind()

    End Sub
    Private Sub BindSelectData()

        Dim objPFC As New FeatureController
        '''  Dim table As DataTable = objPFC.GetProductSelectList(CInt(ViewState("SubkeyID"))).Tables(0)
        '''grdPFS.DataSource = table
        grdPFS.DataBind()
        grdPFS.Visible = True
        btnFSSave.Visible = True
        btnFSDelete.Visible = True

    End Sub


    Private Function GetPFIInfo() As FeatureItemInfo
        Dim PFIInfo As New FeatureItemInfo
        If Not IsNothing(ViewState("SubkeyID")) Then PFIInfo.FeatureID = ViewState("SubkeyID")
        PFIInfo.FeatureGroupID = CInt(ViewState("keyID"))
        PFIInfo.Description = txtDescription.Text
        PFIInfo.FeatureName = txtName.Text
        PFIInfo.IsValid = IIf(ddlIsVaild.SelectedValue = 0, False, True)
        PFIInfo.ItemOrder = txtItemOrder.Text
        PFIInfo.IsSearch = IIf(ddlIsSearch.SelectedValue = 0, False, True)
        PFIInfo.SelectType = ddlSelectType.SelectedValue
        PFIInfo.DataType = ddlDataType.SelectedValue
        Return PFIInfo
    End Function

    Private Function GetPFIInfo(ByVal featureID As Integer, ByVal IsVaild As Boolean, ByVal ItemOrder As Integer) As FeatureItemInfo
        Dim PFIInfo As New FeatureItemInfo
        PFIInfo.FeatureID = featureID
        PFIInfo.ItemOrder = ItemOrder
        PFIInfo.IsValid = IsVaild
        Return PFIInfo

    End Function


    Private Sub AddFeatureSelect()

        If txtFeatureValue.Text.Length = 0 Then Exit Sub
        Dim Values() As String = txtFeatureValue.Text.Split(Environment.NewLine)

        Dim objPFC As New FeatureController


        For Each value As String In Values
            If value.Length > 0 Then
                objPFC.AddProductFeaturSelect(CInt(ViewState("SubkeyID")), value, True)
            End If

        Next

    End Sub


    Public Function GetTempFSTable() As DataTable

        Dim t As New DataTable
        t.Columns.Add("FeatureSelectID", System.Type.GetType("System.Int32"))
        t.Columns.Add("FeatureValue", System.Type.GetType("System.String"))
        t.Columns.Add("IsValid", System.Type.GetType("System.Boolean"))
        Return t

    End Function

#End Region
End Class
