
Imports NetShopForge.Library.News

Partial Class Admin_Management_Controls_EditNewsControl
    Inherits System.Web.UI.UserControl


    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not IsPostBack Then
            Dim newsCategoryID As Integer = Request("newsCategoryID")
            lbBackNewsList.NavigateUrl = "~/Admin/Management/News.aspx?mode=news&NewsCategoryID=" & newsCategoryID
            Dim NewsID As Integer = Request("NewsID")

            Dim action As String = Request("action")
            hfAction.Value = action

            hfNewsID.Value = NewsID
            hfNewsCategoryID.Value = newsCategoryID
            BindData(NewsID, action)
        End If
    End Sub

#Region "---Private Method---"
    Private Sub BindData(ByVal NewsID As Integer, ByVal action As String)
        If IsNothing(action) Then action = "edit"
        Select Case action.ToLower
            Case "edit"
                lblDialogTitle.Text = "༭"
                Dim objNC As New NewsController
                Dim objNews As NewsInfo
                objNews = objNC.GetNews(NewsID)

                txtBody.Text = objNews.Body
                txtSubject.Text = objNews.Subject
                ddlIsSiteNews.SelectedValue = CInt(objNews.IsSiteNews)
            Case "addnew"
                lblDialogTitle.Text = ""
                ' CategoryListControl1.CategoryID = objCI.CategoryID

        End Select

    End Sub

#End Region


    Protected Sub btnSave_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnSave.Click
        'add new
        Dim news As New NewsInfo
        news.NewsID = hfNewsID.Value
        news.Body = txtBody.Text

        news.NewsCategoryID = hfNewsCategoryID.Value
        news.IsSiteNews = CBool(ddlIsSiteNews.SelectedValue)
        news.Subject = txtSubject.Text
        If hfAction.Value.ToLower = "addnew" Then
       
            Try
                NewsController.Instance.AddNews(news)
                ResultMessageControl1.ShowSuccess("ųɹ")
            Catch ex As Exception
                ResultMessageControl1.ShowFail("ʧܣ " & ex.message)
            End Try

        Else
            'update
            Try
                NewsController.Instance.UpdateNews(News)
                ResultMessageControl1.ShowSuccess("ųɹ")
            Catch ex As Exception
                ResultMessageControl1.ShowFail("ʧ ")
            End Try
        End If

    End Sub
End Class
