﻿Imports AspNetSecurity = System.Web.Security
Imports NetShopForge.Library.Shop
Partial Class Admin_Management_Controls_EditShopControl
    Inherits System.Web.UI.UserControl

    Protected Sub btnSave_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnSave.Click

        Dim sMessage As String = ""

        Dim shop As ShopInfo = GetShopInfo()
        Dim objSC As New ShopController

        Try
            Select Case hfAction.Value.ToLower
                Case "edit"
                    sMessage = "店铺更新失败！"
                    shop.ShopID = CInt(hfShopID.Value)
                    objSC.UpdateShop(shop)
                    sMessage = "店铺更新成功！"
                    BindData(hfShopID.Value)
                Case "addnew"
                    sMessage = "店铺更长成功！"
                    Dim ShopID As Integer = objSC.AddShop(shop)
                    sMessage = "店铺添加成功！"
                    ResultMessageControl1.ShowSuccess(sMessage)
                    Response.Redirect(String.Format("~/Admin/Management/Shop.aspx?mode=editShop&ShopID={0}&action=edit", ShopID))
            End Select
        Catch ex As Exception
            ResultMessageControl1.ShowFail(sMessage & ex.Message)
        End Try
    End Sub

    Private Function GetShopInfo() As ShopInfo
        Dim shop As New ShopInfo
        shop.ShopName = txtShopName.Text
        shop.Logo = ImagePickerControl1.GetSelectedImage
        shop.Phone = txtPhone.Text
        shop.Address = txtAddress.Text
        shop.IsCommend = CInt(ddlIsCommend.SelectedValue)
        shop.IsValid = CInt(ddlIsValid.SelectedValue)
        shop.URL = txtURL.Text
        shop.Description = txtDescription.Text
        shop.Email = txtEmail.text
        Return shop
    End Function


    Private Sub BindData(ByVal shopID As Integer)
        Dim objSC As New ShopController
        Dim shop As ShopInfo = Nothing
        If shopID > 0 Then
            shop = objSC.Getshop(shopID)
            If Not IsNothing(shop) Then
                lblDialogTitle.Text = "编辑商铺"
                txtShopName.Text = shop.ShopName
                txtPhone.Text = shop.Phone
                txtAddress.Text = shop.Address
                txtEmail.Text = shop.Email
                txtURL.Text = shop.URL
                ddlIsCommend.SelectedValue = CInt(shop.IsCommend)
                ddlIsValid.SelectedValue = CInt(shop.IsValid)
                ImagePickerControl1.SetImage(shop.Logo)
                txtDescription.Text = shop.Description
            End If
        Else
            lblDialogTitle.Text = "添加新商铺"
            '  hlICON.ImageUrl = String.Format("~/IHttpHandler/ImageHandler.ashx?Imagepath=~/{0}&Size={1}", "", "120,120")
        End If
    End Sub




    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not IsPostBack Then

            Dim shopID As Integer = Request("ShopID")
            Dim action As String = Request("action")
            If shopID = 0 Then shopID = -1
            hfShopID.Value = shopID
            hfAction.Value = action
            If IsNothing(hfAction.Value) Then hfAction.Value = "addnew"
            BindData(hfShopID.Value)

        End If
    End Sub
End Class
