Imports AspNetSecurity = System.Web.Security
Imports AspNetProfile = System.Web.Profile

Partial Class Admin_Management_Controls_EditUserControl
    Inherits System.Web.UI.UserControl


#Region "--Private Method----"


    Private Sub UpdateRoleMembership(ByVal userName As String)
        If String.IsNullOrEmpty(userName) Then
            Return
        End If

        Dim role As String = ddlUserType.SelectedValue


        Dim userInRole As Boolean = Roles.IsUserInRole(userName, role)

        Try
            If (Not userInRole) Then
                Roles.AddUserToRole(userName, role)

            End If
            Select Case role
                Case "Administrator"
                    If Roles.IsUserInRole(userName, "Customer") Then Roles.RemoveUserFromRole(userName, "Customer")
                    If Roles.IsUserInRole(userName, "Vender") Then Roles.RemoveUserFromRole(userName, "Vender")
                Case "Customer"
                    If Roles.IsUserInRole(userName, "Vender") Then Roles.RemoveUserFromRole(userName, "Vender")
                    If Roles.IsUserInRole(userName, "Administrator") Then Roles.RemoveUserFromRole(userName, "Administrator")
                Case "Vender"
                    If Roles.IsUserInRole(userName, "Customer") Then Roles.RemoveUserFromRole(userName, "Customer")
                    If Roles.IsUserInRole(userName, "Administrator") Then Roles.RemoveUserFromRole(userName, "Administrator")
                Case Else
                    If Roles.IsUserInRole(userName, "Customer") Then Roles.RemoveUserFromRole(userName, "Customer")
                    If Roles.IsUserInRole(userName, "Vender") Then Roles.RemoveUserFromRole(userName, "Vender")
                    If Roles.IsUserInRole(userName, "Administrator") Then Roles.RemoveUserFromRole(userName, "Administrator")
            End Select
        Catch ex As Exception
        End Try
    End Sub
    Private Sub UpdateEmail(ByVal userName As String, ByVal email As String)

        Dim mu As MembershipUser = AspNetSecurity.Membership.GetUser(userName)
        mu.Email = email
        If mu.Email <> email Then
            AspNetSecurity.Membership.UpdateUser(mu)
        End If

    End Sub
    Private Sub SaveUserInfo(ByVal userName As String)

        Dim objProfile As AspNetProfile.ProfileBase
        objProfile = AspNetProfile.ProfileBase.Create(userName)
        objProfile.Item("Name") = txtName.Text
        objProfile.Item("Address") = txtAddress.Text
        objProfile.Item("State") = AreaControl1.Province
        objProfile.Item("City") = AreaControl1.City
        objProfile.Item("Area") = AreaControl1.Area
        objProfile.Item("AreaID") = AreaControl1.AreaID
        hfAreaID.Value = AreaControl1.AreaID
        objProfile.Item("ZipCode") = txtZipCode.Text
        objProfile.Item("Phone") = txtPhone.Text

        objProfile.Save()
        UpdateEmail(userName, txtEmail.Text)
        AreaControl1.AreaID = objProfile.Item("AreaID")


    End Sub
    Private Sub GetUserInfo(ByVal userName As String)

        Dim objProfile As AspNetProfile.ProfileBase
        objProfile = AspNetProfile.ProfileBase.Create(userName, True)
        ' Sets all profile properties in Hashtable.
        txtName.Text = objProfile.Item("Name")
        txtAddress.Text = objProfile.Item("Address")
        AreaControl1.AreaID = objProfile.Item("AreaID")
        txtZipCode.Text = objProfile.Item("ZipCode")
        txtPhone.Text = objProfile.Item("Phone")

        Dim mu As MembershipUser = AspNetSecurity.Membership.GetUser(userName)
        txtEmail.Text = mu.Email
        Dim role() As String = Roles.GetRolesForUser(userName)
        If role.Length > 0 Then ddlUserType.SelectedIndex = ddlUserType.SelectedValue = role(0)

    End Sub



#End Region

#Region "--EventArg Method-----"

    Protected Sub btnSave_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnSave.Click
        Try
            UpdateRoleMembership(hfUserName.Value)
            SaveUserInfo(hfUserName.Value)
            ResultMessageControl1.ShowSuccess("ûϢɹ")
        Catch ex As Exception
            ResultMessageControl1.ShowFail("ûϢʧܣԭ" & ex.Message)
        End Try
 

    End Sub

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not IsPostBack Then
            hfUserName.Value = Request("username")
            GetUserInfo(hfUserName.Value)
        End If

    End Sub

#End Region

 
End Class
