Imports NetShopForge.Library.News
Partial Class Admin_Management_Controls_NewsCategoryControl
    Inherits System.Web.UI.UserControl

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not IsPostBack Then
            BindData()
        End If
    End Sub

    Private Sub BindData()
        Dim objNC As New NewsController
        gvNewsCategory.DataSource = objNC.GetNewsCategoryList()
        gvNewsCategory.DataBind()
    End Sub

    Protected Sub btnAddNew_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnAddNew.Click
        Dim URL As String = "~/Admin/Management/News.aspx?mode=editnewscategory&action=addnew"
        My.Response.Redirect(URL)

    End Sub

    Protected Sub btnDelete_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnDelete.Click
        Try
            For i As Integer = 0 To gvNewsCategory.Rows.Count - 1
                If gvNewsCategory.Rows(i).RowType = DataControlRowType.DataRow Then
                    Dim cbSelect As CheckBox = CType(gvNewsCategory.Rows(i).FindControl("cbSelect"), CheckBox)
                    Dim NewsCategoryID As String = gvNewsCategory.DataKeys(i).Value
                    If cbSelect.Checked Then NewsController.Instance.DeleteNewsCategory(NewsCategoryID)
                End If
            Next i
            BindData()
            ResultMessageControl1.ShowSuccess("ɾɹ")
        Catch ex As Exception
            ResultMessageControl1.ShowFail("ɾʧܣ" & ex.Message)
        End Try
    End Sub

    Protected Sub btnUpdate_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnUpdate.Click
        Try
            For i As Integer = 0 To gvNewsCategory.Rows.Count - 1
                If gvNewsCategory.Rows(i).RowType = DataControlRowType.DataRow Then

                    Dim ddlIsValid As DropDownList = CType(gvNewsCategory.Rows(i).FindControl("ddlIsValid"), DropDownList)
                    Dim ddlIsSiteNews As DropDownList = CType(gvNewsCategory.Rows(i).FindControl("ddlIsSiteNews"), DropDownList)

                    Dim NewsCategoryID As String = gvNewsCategory.DataKeys(i).Value
               
                    NewsController.Instance.UpdateNewsCategoryQuick(NewsCategoryID, CBool(ddlIsValid.SelectedValue), CBool(ddlIsSiteNews.SelectedValue))
                End If
            Next i
            BindData()
            ResultMessageControl1.ShowSuccess("³ɹ")
        Catch ex As Exception
            ResultMessageControl1.ShowFail("ʧܣ" & ex.Message)
        End Try
    End Sub

    Protected Sub btnEdit_Click(ByVal sender As Object, ByVal e As System.EventArgs)
        My.Response.Redirect(String.Format("~/Admin/Management/News.aspx?mode=editnewscategory&newsCategoryID={0}&action=edit", CType(sender, Button).CommandArgument))
    End Sub

    Protected Sub gvNewsCategory_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles gvNewsCategory.SelectedIndexChanged

    End Sub
End Class
