
Imports NetShopForge.Library.News

Partial Class Admin_Management_Controls_NewsControl
    Inherits System.Web.UI.UserControl

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        Dim newsCategoryID As Integer = Request("newsCategoryID")
        Dim ncc As New NewsController
        hfNewsCategoryID.Value = newsCategoryID
        NewsCategory.Text = ncc.GetNewsCategory(newsCategoryID).Name
        BindData()
    End Sub

    Private Sub BindData()
        Dim newsCategoryID As Integer = hfNewsCategoryID.Value
        Dim objNC As New NewsController
        gvNews.DataSource = objNC.GetNewsList(newsCategoryID)
        gvNews.DataBind()
    End Sub

    Protected Sub btnAddNew_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnAddNew.Click
        Dim url As String = String.Format("~/Admin/Management/News.aspx?mode=editNews&action=addnew&newscategoryid={0}", hfNewsCategoryID.Value)
        Page.Response.Redirect(url)
    End Sub

    Protected Sub btnDelete_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnDelete.Click
        Try

            For i As Integer = 0 To gvNews.Rows.Count - 1
                If gvNews.Rows(i).RowType = DataControlRowType.DataRow Then
                    Dim cbSelect As CheckBox = CType(gvNews.Rows(i).FindControl("cbSelect"), CheckBox)
                    Dim newsID As String = gvNews.DataKeys(i).Value
                    If cbSelect.Checked Then NewsController.Instance.DeleteNews(newsID)
                End If
            Next i

            BindData()
            ResultMessageControl1.ShowSuccess("ɾɹ")
        Catch ex As Exception
            ResultMessageControl1.ShowFail("ɾʧܣ" & ex.Message)
        End Try
    End Sub

    Protected Sub btnUpdate_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnUpdate.Click
        Try
            For i As Integer = 0 To gvNews.Rows.Count - 1
                If gvNews.Rows(i).RowType = DataControlRowType.DataRow Then

                    Dim ddlIsValid As DropDownList = CType(gvNews.Rows(i).FindControl("ddlIsValid"), DropDownList)
                    Dim ddlIsSiteNews As DropDownList = CType(gvNews.Rows(i).FindControl("ddlIsSiteNews"), DropDownList)

                    Dim NewsID As String = gvNews.DataKeys(i).Value

                    NewsController.Instance.UpdateNewsQuick(NewsID, CBool(ddlIsValid.SelectedValue), CBool(ddlIsSiteNews.SelectedValue))
                End If
            Next i
            BindData()
            ResultMessageControl1.ShowSuccess("Ÿ³ɹ")
        Catch ex As Exception
            ResultMessageControl1.ShowFail("Ÿʧܣ" & ex.Message)
        End Try
    End Sub

 
End Class
