Imports NetShopForge.Library.User
Imports System.Collections.Generic
Imports AspNetSecurity = System.Web.Security
Imports NetShopForge.Library.Shop

Partial Class Admin_Management_Controls_ShopControl
    Inherits System.Web.UI.UserControl

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not IsPostBack Then
            hfSearchText.Value = ""
            BindData()
        End If
    End Sub

    Private Sub BindData()

        Dim shopController As New ShopController
        gvShop.DataSource = shopController.GetShops
        gvShop.DataBind()

    End Sub



    Protected Sub btnUserAddNew_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnShopAddNew.Click
        My.Response.Redirect("~/Admin/Management/shop.aspx?mode=editShop&action=addNew")
    End Sub


    Protected Sub btnUserDelete_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnShopDelete.Click
        Try
            Dim objSC As New ShopController
            For i As Integer = 0 To gvShop.Rows.Count - 1
                If gvShop.Rows(i).RowType = DataControlRowType.DataRow Then
                    Dim cbSelect As CheckBox = CType(gvShop.Rows(i).FindControl("cbSelect"), CheckBox)
                    Dim shopID As Integer = CInt(gvShop.DataKeys(i).Value)
                    If cbSelect.Checked Then objSC.DeleteShop(shopID)
                End If
            Next i
            BindData()
            ResultMessageControl1.ShowSuccess("ɾɹ")
        Catch ex As Exception
            ResultMessageControl1.ShowFail("ɾʧܣ" & ex.Message)
        End Try


    End Sub

    Protected Sub btnShopUpdate_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnShopUpdate.Click


        Try
            For i As Integer = 0 To gvShop.Rows.Count - 1
                If gvShop.Rows(i).RowType = DataControlRowType.DataRow Then

                    Dim ddlIsValid As DropDownList = CType(gvShop.Rows(i).FindControl("ddlIsValid"), DropDownList)
                    Dim ddlIsCommend As DropDownList = CType(gvShop.Rows(i).FindControl("ddlIsCommend"), DropDownList)
                    Dim txtItemOrder As TextBox = CType(gvShop.Rows(i).FindControl("txtItemOrder"), TextBox)

                    Dim shopID As String = gvShop.DataKeys(i).Value
                    Dim itemOrder As Integer = 0
                    If IsNumeric(txtItemOrder.Text) Then
                        itemOrder = CInt(txtItemOrder.Text)
                    End If

                    Dim objSC As New ShopController
                    objSC.UpdateShopQuick(shopID, itemOrder, CInt(ddlIsCommend.SelectedValue), CInt(ddlIsValid.SelectedValue))
                End If
            Next i
            BindData()
            ResultMessageControl1.ShowSuccess("ûб³ɹ")
        Catch ex As Exception
            ResultMessageControl1.ShowFail("ûбʧܣ" & ex.Message)
        End Try


    End Sub


    Protected Sub gvShop_RowDataBound(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.GridViewRowEventArgs) Handles gvShop.RowDataBound
        If e.Row.RowType = DataControlRowType.DataRow Then


        End If
    End Sub

End Class
