Imports NetShopForge.Library.ShopHelp
Partial Class Admin_Management_Controls_ShopHelpCategoryControl
    Inherits System.Web.UI.UserControl

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not IsPostBack Then
            BindData()
        End If
    End Sub

    Private Sub BindData()
        Dim objNC As New ShopHelpController
        gvShopHelpCategory.DataSource = objNC.GetShopHelpCategoryList()
        gvShopHelpCategory.DataBind()
    End Sub

    Protected Sub btnAddNew_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnAddNew.Click
        Dim URL As String = "~/Admin/Management/ShopHelp.aspx?mode=editShopHelpcategory&action=addnew"
        My.Response.Redirect(URL)

    End Sub

    Protected Sub btnDelete_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnDelete.Click
        Try
            For i As Integer = 0 To gvShopHelpCategory.Rows.Count - 1
                If gvShopHelpCategory.Rows(i).RowType = DataControlRowType.DataRow Then
                    Dim cbSelect As CheckBox = CType(gvShopHelpCategory.Rows(i).FindControl("cbSelect"), CheckBox)
                    Dim ShopHelpCategoryID As String = gvShopHelpCategory.DataKeys(i).Value
                    If cbSelect.Checked Then ShopHelpController.Instance.DeleteShopHelpCategory(ShopHelpCategoryID)
                End If
            Next i
            BindData()
            ResultMessageControl1.ShowSuccess("ɾɹ")
        Catch ex As Exception
            ResultMessageControl1.ShowFail("ɾʧܣ" & ex.Message)
        End Try
    End Sub

    Protected Sub btnUpdate_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnUpdate.Click

        Try
            For i As Integer = 0 To gvShopHelpCategory.Rows.Count - 1
                If gvShopHelpCategory.Rows(i).RowType = DataControlRowType.DataRow Then

                    Dim txtItemOrder As TextBox = CType(gvShopHelpCategory.Rows(i).FindControl("txtItemOrder"), TextBox)

                    Dim ShopHelpCategoryID As String = gvShopHelpCategory.DataKeys(i).Value
                    Dim itemOrderID As Integer
                    If txtItemOrder.Text.Length = 0 OrElse Not IsNumeric(txtItemOrder.Text.Length) Then
                        itemOrderID = 0
                    Else
                        itemOrderID = txtItemOrder.Text
                    End If
                    ShopHelpController.Instance.UpdateShopHelpCategoryItemOrder(ShopHelpCategoryID, itemOrderID)

                End If
            Next i
            BindData()
            ResultMessageControl1.ShowSuccess("³ɹ")
        Catch ex As Exception
            ResultMessageControl1.ShowFail("ʧܣ" & ex.Message)
        End Try
    End Sub

    Protected Sub btnEdit_Click(ByVal sender As Object, ByVal e As System.EventArgs)
        My.Response.Redirect(String.Format("~/Admin/Management/ShopHelp.aspx?mode=editShopHelpcategory&ShopHelpCategoryID={0}&action=edit", CType(sender, Button).CommandArgument))
    End Sub
End Class
