Imports NetShopForge.Library.Order
Partial Class Admin_Management_Controls_OrderListControl
    Inherits System.Web.UI.UserControl


#Region "---Event Method---"

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not IsPostBack Then
            Dim objOC As New OrderController
            BindData()
            BindSearch()
        End If
    End Sub
    Protected Sub ChangePage(ByVal src As Object, ByVal e As EventArgs) Handles Pager.PageChanged
        ' Dim startTime As System.DateTime = System.DateTime.Now

        BindData()
        'Dim endTime As System.DateTime = System.DateTime.Now
        'Dim ts As System.TimeSpan = endTime - startTime
        ''   Label1.Text = "ҳִʱ:" & ts.Milliseconds & " "
    End Sub

#End Region

#Region "---Private Method---"

    Private Sub BindData()
        Dim sqlWhere As String = GetSqlWhere()
        '  Dim objOC As New OrderController
        Pager.RecordCount = OrderController.GetOrderNumberByPage(sqlWhere)
        gvOrders.DataSource = OrderController.GetOrderList(Pager.PageSize, Pager.CurrentPageIndex, sqlWhere)
        gvOrders.DataBind()
        Pager.CustomInfoHTML = "¼:" + Pager.RecordCount.ToString()
        Pager.CustomInfoHTML += " ҳ:" + Pager.PageCount.ToString()
        Pager.CustomInfoHTML += " ǰҳ:" + Pager.CurrentPageIndex.ToString()
    End Sub

    Private Sub BindSearch()
        Dim I As Integer
        ddlOrderStatus.Items.Clear()
        ddlOrderStatus.Items.Add(New ListItem("ȫ״̬", -1))
        For Each I In [Enum].GetValues(GetType(OrderStatus))
            ddlOrderStatus.Items.Add(New ListItem(OrderController.GetChineseOrderStatus(I), I))
        Next
        dpStart.SelectedDate = Today.AddDays(-14)
        dpEnd.SelectedDate = Today

        ddlSearch.Items.Add(New ListItem("", "OrderNumber"))
        ddlSearch.Items.Add(New ListItem("û", "UserName"))
        ddlSearch.Items.Add(New ListItem("<(ܽ)", "lessTotle"))
        ddlSearch.Items.Add(New ListItem("=(ܽ)", "equalsTotle"))
        ddlSearch.Items.Add(New ListItem(">(ܽ)", "greatTotle"))

    End Sub

    Private Function GetSqlWhere() As String

        If hfSqlWhere.Value.Length > 0 Then
            Return hfSqlWhere.Value
        Else
            Return ""
        End If

    End Function

    Private Sub SetSqlWhere()

        Dim sb As New StringBuilder
        sb.Append(String.Format("( OrderDate BETWEEN '{0}' AND '{1}')", dpStart.SelectedDate.ToString("yyyy-MM-dd"), dpEnd.SelectedDate.AddDays(1).ToString("yyyy-MM-dd")))
        If ddlOrderStatus.SelectedIndex <> 0 Then
            sb.Append(String.Format(" AND (OrderStatus={0}) ", ddlOrderStatus.SelectedValue))
        End If

        If txtSearch.Text.Trim.Length > 0 Then
            Select Case ddlOrderStatus.SelectedValue
                Case "OrderNumber"
                    sb.Append(String.Format(" AND (OrderNumber Like '%{0}') ", txtSearch.Text.Replace("'", "''")))
                Case "UserName"
                    sb.Append(String.Format(" AND (UserName Like '%{0}') ", txtSearch.Text.Replace("'", "''")))
                Case "lessTotle"
                    sb.Append(String.Format(" AND (TotalFee<{0}) ", txtSearch.Text.Replace("'", "''")))
                Case "equalsTotle"
                    sb.Append(String.Format(" AND (TotalFee={0}) ", txtSearch.Text.Replace("'", "''")))
                Case "greatTotle"
                    sb.Append(String.Format(" AND (TotalFee>{0}) ", txtSearch.Text.Replace("'", "''")))
            End Select
        End If
        hfSqlWhere.Value = sb.ToString
    End Sub

#End Region

    Protected Sub gvOrders_RowDataBound(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.GridViewRowEventArgs) Handles gvOrders.RowDataBound
        If e.Row.RowType = DataControlRowType.DataRow Then
            Dim lbOrderStatus As Label = CType(e.Row.FindControl("lbOrderStatus"), Label)
            Dim I As Integer = CInt(lbOrderStatus.Text)
            lbOrderStatus.Text = Order.OrderController.GetChineseOrderStatus(I)
            Dim actions As Generic.List(Of OrderAction) = Order.OrderController.GetOrderActionsForAdmin(I)
            Dim ac As OrderAction
            Dim sb As New StringBuilder


            For Each ac In actions
                If ac = OrderAction.B_Review Then Continue For
                Dim Text As String = Order.OrderController.GetChineseOrderAction(ac)
                Dim Url As String = String.Format("{0}?mode=orderitem&orderid={1}&action={2}", Page.ResolveUrl("~/Admin/Management/Orders.aspx"), gvOrders.DataKeys(e.Row.RowIndex).Value, CInt(ac))
                sb.Append(String.Format("<a href =""{1}"">{0}</a>   ", Text, Url))
            Next

            Dim Operation As Literal = CType(e.Row.FindControl("Operation"), Literal)

            Operation.Text = sb.ToString
        End If


    End Sub

    Protected Sub btnSearch_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnSearch.Click

        SetSqlWhere()
        BindData()

    End Sub

    Protected Sub btnDelete_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnDelete.Click
        For i As Integer = 0 To gvOrders.Rows.Count - 1
            If gvOrders.Rows(i).RowType = DataControlRowType.DataRow Then
                Dim cbSelect As CheckBox = CType(gvOrders.Rows(i).FindControl("cbSelect"), CheckBox)
                Dim orderid As Integer = gvOrders.DataKeys(i).Value
                If cbSelect.Checked Then OrderController.DeleteOrder(orderid)
            End If
        Next i
        BindData()
    End Sub

End Class
