﻿<%@ Control Language="VB" AutoEventWireup="false" CodeFile="UserControl.ascx.vb"
    Inherits="Admin_Management_Controls_UserControl" %>
<%@ Register Src="../../Controls/ResultMessageControl.ascx" TagName="ResultMessageControl"
    TagPrefix="uc2" %>
<%@ Register Src="../../Controls/CheckAllCheckBoxControl.ascx" TagName="CheckAllCheckBoxControl"
    TagPrefix="uc1" %>
<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>
            <div class ="blankbox"></div>
    <div class ="graytext">通过用户管理使您能够查看或更改该用户的密码或其他属性。 若要禁止该用户登录到您的应用程序，但在数据库中保留其信息，可通过将活动状态设置为否。
    </div>
    <uc2:ResultMessageControl
            ID="ResultMessageControl1" runat="server" />
            <div class ="blankbox"></div>
<div class="dialog-title">
    <asp:Label ID="lblDialogTitle" runat="server">用户列表</asp:Label>
</div>
<div class="dialog-box">
    <div class="row">
        <asp:DropDownList ID="ddlSearch" runat="server">
            <asp:ListItem Text="用户名称"></asp:ListItem>
            <asp:ListItem Text="电子邮件"></asp:ListItem>
        </asp:DropDownList>&nbsp;<asp:DropDownList ID="ddlUserType" runat="server">
            <asp:ListItem Text="全部用户类型" Value="All"></asp:ListItem>
            <asp:ListItem Text="管理员" Value="Administrator"></asp:ListItem>
            <asp:ListItem Text="顾客" Value="Customer"></asp:ListItem>
                        <asp:ListItem Text="商家" Value="Vender"></asp:ListItem>
        </asp:DropDownList>
        <asp:TextBox ID="txtSearch" runat="server" value="输入查询关键字" onmouseover="this.focus()"
            onfocus="this.select()" onclick="if(this.value=='输入查询关键字')this.value=''"></asp:TextBox>
        <asp:Button ID="btnSearch" runat="server" Text="查找用户"></asp:Button></div>
    <div class="grid">
        <asp:GridView ID="gvUser" runat="server" AllowPaging="True" AutoGenerateColumns="False"
            Width="100%" EmptyDataText="没有用户！" DataKeyNames="UserName">
            <Columns>
                <asp:TemplateField>
                    <ItemTemplate>
                        <asp:CheckBox ID="cbSelect" runat="server" />
                    </ItemTemplate>
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle Width="25px" HorizontalAlign="Center" />
                    <HeaderTemplate>
                        <uc1:CheckAllCheckBoxControl ID="CheckAllCheckBoxControl1" runat="server" Prefix="gvUser" />
                    </HeaderTemplate>
                </asp:TemplateField>
                <asp:HyperLinkField DataNavigateUrlFields="UserName" DataNavigateUrlFormatString="~/Admin/Management/Users.aspx?mode=edituser&amp;username={0}"
                    DataTextField="UserName" HeaderText="用户名称" />
                <asp:TemplateField HeaderText="Email">
                    <ItemTemplate>
                        <asp:HyperLink ID="EmailLink" runat="server" NavigateUrl='<%#Eval("Email", "mailto:{0}")%>'
                            Text='<%#Eval("Email")%>'></asp:HyperLink>
                    </ItemTemplate>
                    <ItemStyle HorizontalAlign="Left" Width="180px" />
                </asp:TemplateField>
                <asp:BoundField DataField="LastActivityDate" DataFormatString="{0:d}" HeaderText="上次访问时间" />
                <asp:TemplateField HeaderText="用户类型">
                    <ItemTemplate>
                        <asp:Label ID="lbUserType" runat="server"></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:CheckBoxField HeaderText="是否在线" DataField="IsOnline">
                    <ItemStyle Width="60px" HorizontalAlign="Center" />
                    <HeaderStyle Width="60px" />
                </asp:CheckBoxField>
                <asp:TemplateField HeaderText="活动">
                    <HeaderStyle HorizontalAlign="Center" Width="60px" />
                    <ItemStyle HorizontalAlign="Center" Width="60px" />
                    <ItemTemplate>
                        <asp:DropDownList ID="ddlIsApproved" runat="server" SelectedValue='<%#Cint(Eval("IsApproved")) %>'>
                            <asp:ListItem Value="-1">是</asp:ListItem>
                            <asp:ListItem Value="0">否</asp:ListItem>
                        </asp:DropDownList>
                    </ItemTemplate>
                    <FooterStyle Width="80px" />
                </asp:TemplateField>
            </Columns>
            <PagerSettings Visible="False" />
        </asp:GridView>
    </div>
    <div class="grid-pager">
        <webdiyer:AspNetPager ID="Pager" runat="server" EnableTheming="False" FirstPageText='<span   style="font-family:Webdings, Wingdings" >9</span>'
            HorizontalAlign="Left" LastPageText='<span   style="font-family:Webdings, Wingdings" >:</span>'
            NextPageText='<span   style="font-family:Webdings, Wingdings" >4</span>' NumericButtonCount="8"
            NumericButtonTextFormatString="[{0}]" OnPageChanged="ChangePage" PageSize="5"
            PagingButtonSpacing="8px" PrevPageText='<span   style="font-family:Webdings, Wingdings" >3</span>'
            ShowCustomInfoSection="Right" SubmitButtonText="转页" Width="100%" CustomInfoSectionWidth="75%"
            ShowBoxThreshold="5"  Align="Right" ShowInputBox="Never">
        </webdiyer:AspNetPager>
    </div>
    <div class ="blankbox"></div>
    <div class="row">
        <asp:Button ID="btnUserAddNew" runat="server" Text="添加新用户" />
        <asp:Button ID="btnUserDelete" runat="server" Text="删除选中" OnClientClick="javascript:return toDel('gvUser')" />
        <asp:Button ID="btnUserUpdate" runat="server" Text="更新" OnClientClick="javascript:return confirm('你确认要执行更新操作？');"
            Width="75px" /></div>
</div>
<asp:HiddenField ID="hfSearchText" runat="server" />
