Imports NetShopForge.Library.User
Imports System.Collections.Generic
Imports AspNetSecurity = System.Web.Security

Partial Class Admin_Management_Controls_UserControl
    Inherits System.Web.UI.UserControl

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not IsPostBack Then
            hfSearchText.Value = ""

            BindData()
        End If
    End Sub

    Private Sub BindData()

        Dim msuCollection As MembershipUserCollection = Nothing
        Dim totalRecords As Integer = 0
        Dim SearchText As String = hfSearchText.Value

        If SearchText.Trim().Length <> 0 Then
            SearchText = SearchText.Replace("*", "%")
            SearchText = SearchText.Replace("?", "_")
            'INSTANT VB NOTE: Embedded comments are not maintained by Instant VB
            'ORIGINAL LINE: if (ddlSearch.SelectedIndex == 0 /* UserName */)
            If ddlSearch.SelectedIndex = 0 Then
                msuCollection = Membership.FindUsersByName(SearchText, Pager.CurrentPageIndex - 1, Pager.PageSize, totalRecords)
            Else
                msuCollection = Membership.FindUsersByEmail(SearchText, Pager.CurrentPageIndex - 1, Pager.PageSize, totalRecords)
            End If
        Else
            msuCollection = AspNetSecurity.Membership.GetAllUsers(Pager.CurrentPageIndex - 1, Pager.PageSize, totalRecords)
        End If

        'filter role 
        'ORIGINAL LINE: if (dllUserType.SelectedIndex == 0 /* all */ no filter)
        If ddlUserType.SelectedIndex = 0 Then
            gvUser.DataSource = msuCollection
        Else
            Dim users As New Generic.List(Of MembershipUser)
            For Each mu As MembershipUser In msuCollection
                If Roles.IsUserInRole(mu.UserName, ddlUserType.SelectedValue) Then users.Add(mu)
            Next
            totalRecords = users.Count
            gvUser.DataSource = users
        End If



        Pager.RecordCount = totalRecords
        gvUser.DataBind()
        Pager.CustomInfoHTML = "¼:" + Pager.RecordCount.ToString()
        Pager.CustomInfoHTML += " ҳ:" + Pager.PageCount.ToString()
        Pager.CustomInfoHTML += " ǰҳ:" + Pager.CurrentPageIndex.ToString()
    End Sub

    Protected Sub ChangePage(ByVal src As Object, ByVal e As EventArgs) Handles Pager.PageChanged
        ' Dim startTime As System.DateTime = System.DateTime.Now

        BindData()
        'Dim endTime As System.DateTime = System.DateTime.Now
        'Dim ts As System.TimeSpan = endTime - startTime
        ''   Label1.Text = "ҳִʱ:" & ts.Milliseconds & " "
    End Sub


    Protected Sub btnSearch_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnSearch.Click
        hfSearchText.Value = txtSearch.Text
        If hfSearchText.Value = "ѯؼ" Then hfSearchText.Value = ""
        BindData()
        txtSearch.Text = ""
    End Sub


    Protected Sub SearchForUsers()

        Dim msuCollection As MembershipUserCollection = Nothing
        Dim text As String = txtSearch.Text
        text = text.Replace("*", "%")
        text = text.Replace("?", "_")
        Dim total As Integer = 0
        Dim totalRecords As Integer
        If text.Trim().Length <> 0 Then
            'INSTANT VB NOTE: Embedded comments are not maintained by Instant VB
            'ORIGINAL LINE: if (dropDown.SelectedIndex == 0 /* userID */)
            If ddlSearch.SelectedIndex = 0 Then
                msuCollection = Membership.FindUsersByName(text, Pager.CurrentPageIndex - 1, Pager.PageSize, totalRecords)
            Else
                msuCollection = Membership.FindUsersByEmail(text, Pager.CurrentPageIndex - 1, Pager.PageSize, totalRecords)
            End If
        End If

        Dim role As String = ddlUserType.SelectedValue

        If role <> "All" Then
            For Each mu As MembershipUser In msuCollection
                If Not Roles.IsUserInRole(mu.UserName, role) Then msuCollection.Remove(mu.UserName)
            Next
        End If

        Pager.RecordCount = msuCollection.Count
        gvUser.PageIndex = 0
        gvUser.DataSource = msuCollection
        gvUser.DataBind()

    End Sub

    Protected Sub btnUserAddNew_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnUserAddNew.Click
        My.Response.Redirect("~/Admin/Management/Users.aspx?mode=addUser")
    End Sub


    Protected Sub btnUserDelete_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnUserDelete.Click
        Try
            For i As Integer = 0 To gvUser.Rows.Count - 1
                If gvUser.Rows(i).RowType = DataControlRowType.DataRow Then
                    Dim cbSelect As CheckBox = CType(gvUser.Rows(i).FindControl("cbSelect"), CheckBox)
                    Dim username As String = gvUser.DataKeys(i).Value
                    If cbSelect.Checked Then Membership.DeleteUser(username, True)
                End If
            Next i
            BindData()
            ResultMessageControl1.ShowSuccess("ûбɾɹ")
        Catch ex As Exception
            ResultMessageControl1.ShowFail("ûбɾʧܣ" & ex.Message)
        End Try

  
    End Sub

    Protected Sub btnUserUpdate_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnUserUpdate.Click

 
        Try
            For i As Integer = 0 To gvUser.Rows.Count - 1
                If gvUser.Rows(i).RowType = DataControlRowType.DataRow Then

                    Dim ddlIsApproved As DropDownList = CType(gvUser.Rows(i).FindControl("ddlIsApproved"), DropDownList)

                    Dim UserName As String = gvUser.DataKeys(i).Value

                    Dim user As MembershipUser = Membership.FindUsersByName(UserName)(UserName)
                    user.IsApproved = CBool(ddlIsApproved.SelectedValue)
                    Membership.UpdateUser(user)

                End If
            Next i
            BindData()
            ResultMessageControl1.ShowSuccess("ûб³ɹ")
        Catch ex As Exception
            ResultMessageControl1.ShowFail("ûбʧܣ" & ex.Message)
        End Try


    End Sub

  
    Protected Sub gvUser_RowDataBound(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.GridViewRowEventArgs) Handles gvUser.RowDataBound

        If e.Row.RowType = DataControlRowType.DataRow Then

            Dim lbUserType As Label = CType(e.Row.Cells(4).FindControl("lbUserType"), Label)
            Dim UserName As String = gvUser.DataKeys(e.Row.RowIndex).Value
            If UserName = Resources.GlobalResources.SuperAdmin Then 'My.User.Name Then
                e.Row.Enabled = False
                'Dim cbSelect As CheckBox = CType(e.Row.Cells(0).FindControl("cbSelect"), CheckBox)
                'cbSelect.Enabled = False
            End If
            Dim roles() As String = AspNetSecurity.Roles.GetRolesForUser(UserName)
            If roles.Length > 0 Then
                Select Case roles(0)
                    Case "Administrator"
                        lbUserType.Text = "Ա"
                    Case "Customer"
                        lbUserType.Text = "˿"
                    Case "Vender"
                        lbUserType.Text = "̼"
                    Case Else
                        lbUserType.Text = "***"
                End Select
              
            Else
                lbUserType.Text = "δ"
            End If


        End If

    End Sub
End Class
