Imports NetShopForge.Library.Order
Imports NetShopForge.Library.Address


Imports NetShopForge.Library.WantBuy
Partial Class Admin_Management_Controls_WantBuyItemControl
    Inherits System.Web.UI.UserControl

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load

        If Not IsPostBack Then
            Dim action As String = Request("action")
            Dim wantBuyID As Integer = Request("wantbuyid")
            If wantBuyID = 0 Then

                Response.Redirect("~/Admin/Management/WantBuy.aspx")

            Else

                hfWantBuyID.Value = wantBuyID
                BindData(wantBuyID)
            End If
        End If

    End Sub


    Private Sub BindData(ByVal wantbuyID As Integer)

        Dim wbInfo As WantBuyInfo = WantBuyController.Instance.GetWantBuy(wantbuyID)
        orderNumber.Text = wbInfo.WantBuyNumber
        Dim I As Integer = CInt(wbInfo.OrderStatus)
        OrderStatus.Text = Order.OrderController.GetChineseOrderStatus(I)
        productName.Text = wbInfo.ProductName
        productURL.Text = wbInfo.URL
        orderType.Text = GetWantBuyType(wbInfo.Type)
        productFeature.Text = wbInfo.Feature
        productCommend.Text = wbInfo.Comment


        Dim objAC As New AddressController
        Dim address As AddressInfo = objAC.GetAddress(wbInfo.AddressID)
        sendaddress.Text = String.Format("{0},{1},{2},{3},{4},{5},{6}/{7}", address.FirstName, address.Province, address.City, address.Area, address.Zip, address.Address1, address.MobilePhone, address.Phone)


        If wbInfo.OrderStatus = Order.OrderStatus.OrderComplete OrElse wbInfo.OrderStatus = Order.OrderStatus.OrderCancelledPriorToShipping Then

            ddlOrderStatus.SelectedValue = CInt(wbInfo.OrderStatus)
            ddlOrderStatus.Enabled = False
            btnChangeOrderStatus.Visible = False
        Else
            ddlOrderStatus.Enabled = True
            btnChangeOrderStatus.Visible = True
        End If

        BindOrderStatus(wbInfo.OrderStatus)

    End Sub

    Private Function GetWantBuyType(ByVal type As WantBuyType) As String
        Dim result As String = ""
        Select Case type
            Case WantBuyType.auction
                result = "ĵ"
            Case WantBuyType.buy
                result = ""
        End Select

        Return result
    End Function


    Private Sub BindOrderStatus(ByVal status As Order.OrderStatus)
        Dim I As Integer
        ddlOrderStatus.Items.Clear()
        For Each I In [Enum].GetValues(GetType(OrderStatus))
            Dim item As New ListItem
            item.Text = OrderController.GetChineseOrderStatus(I)
            item.Value = I
            ddlOrderStatus.Items.Add(item)
            If I = CInt(status) Then
                item.Selected = True
                item.Text = item.Text & "(ǰ״̬)"
            End If


        Next


    End Sub


    Private Sub UpdateOrderStatus(ByVal status As OrderStatus)
        OrderController.UpdateOrderStatus(hfWantBuyID.Value, status)
        Dim actions As Generic.List(Of OrderAction) = OrderController.GetOrderActionsForAdmin(status)
        hfOrderStatus.Value = CInt(status)

    End Sub

    Protected Sub btnChangeOrderStatus_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnChangeOrderStatus.Click
        Try
            Dim wantBuyID As Integer = hfWantBuyID.Value
            WantBuyController.Instance.UpdateWantBuyOrderStatus(wantBuyID, CInt(ddlOrderStatus.SelectedValue))
            BindData(wantBuyID)

            ResultMessageControl1.ShowSuccess("Ĵ״̬ɹ")
        Catch ex As Exception
            ResultMessageControl1.ShowFail("Ĵ״̬ʧܣ")
        End Try


    End Sub
End Class
