Imports NetShopForge.Library.SpecialOffer
Imports NetShopForge.Library.Product
Imports System
Imports System.Collections.Generic
Partial Class Admin_Merchandising_Controls_BonusesControl
    Inherits System.Web.UI.UserControl

    '   Public SpecailOffer As SpecialOffer.SpecialOfferInfo
    Private Const GIVEDISCOUNT As String = ""
    Private Const SPECIALPRICE As String = "ؼۻƷ"
    Private Const OFFERFREESHIPPING As String = "ͻ"
    Private Const GIVEBONUSPOINT As String = ""
    Private Const OFFERMEMBErShip As String = ""
    Private Const GIVECOUPON As String = ""
    Private Const INCOMPLETE As String = "δ"



    Public Property BonusType() As BonusType
        Get
            Return rblBonuses.SelectedValue
        End Get
        Set(ByVal value As BonusType)
            rblBonuses.SelectedValue = value

        End Set
    End Property

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not IsPostBack Then
            Dim offerID As String = Request("offerid")
            If IsNothing(offerID) Then My.Response.Redirect("~/Admin/Merchandising/Offers.aspx")
            hfOfferID.Value = offerID
            Dim so As SpecialOfferInfo
            so = SpecialOfferController.GetSpecialOffer(hfOfferID.Value)
            SpecialOfferNavControl1.Enabled = (so.Status <> SpecialOfferStatus.Incomplete)
            BonusType = so.BonusType
            BindData()
            NetShopForge.Library.Category.CategoryTree.Instance.SetCategoryList(ddlCategory, "")

        End If
    End Sub

    Protected Sub rblBonuses_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles rblBonuses.SelectedIndexChanged
        'mvConditions.ActiveViewIndex = rblBonuses.SelectedValue
        pChooseProducts.Visible = (CInt(rblBonuses.SelectedValue) < 3)
        '    rblProductCategory.Visible = CInt(rblBonuses.SelectedValue) <> 1
        Dim objSPC As New SpecialOfferController
        objSPC.UpdateSpecailOfferType(CInt(hfOfferID.Value), "B", CInt(rblBonuses.SelectedValue))
        BindData()

    End Sub


    Protected Sub ChooseProductsControl1_ProductSelected1(ByVal selectedProducts As System.Collections.Generic.List(Of NetShopForge.Library.Product.ProductSelectedInfo)) Handles ChooseProductsControl1.ProductSelected
        Dim objSPC As New SpecialOfferController
        Dim offerID As Integer = CInt(hfOfferID.Value)
        Dim ps As ProductSelectedInfo
        Select Case BonusType
            Case BonusType.GiveDiscount
                For Each ps In selectedProducts
                    Dim Product As New SpecialOfferProductsInfo
                    Product.OfferID = offerID
                    Product.ProductID = ps.ProductID
                    Product.Quantity = 0
                    Product.CategoryID = 0
                    Product.Type = "B"
                    Product.Type2 = BonusType
                    objSPC.AddSpecialOfferProducts(Product)
                Next

            Case BonusType.OfferFreeShipping
                For Each ps In selectedProducts
                    Dim Product As New SpecialOfferProductsInfo
                    Product.OfferID = offerID
                    Product.ProductID = ps.ProductID
                    Product.Quantity = 0
                    Product.CategoryID = 0
                    Product.Type = "B"
                    Product.Type2 = BonusType
                    objSPC.AddSpecialOfferProducts(Product)
                Next

            Case BonusType.SpecialPrice

                For Each ps In selectedProducts
                    Dim Product As New SpecialOfferBonusPriceInfo
                    Product.OfferID = offerID
                    Product.ProductID = ps.ProductID
                    Product.ProductName = ps.productName
                    Product.Price = ps.Price
                    Product.AdjustPrice = ps.Price
                    objSPC.AddSpecailOffersBonusPrice(Product)
                Next

        End Select
        BindData()

    End Sub
    Protected Sub btnAddCategory_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnAddCategory.Click

        Dim offerID As Integer = CInt(hfOfferID.Value)
        Dim objSPC As New SpecialOfferController
        Dim Product As New SpecialOfferProductsInfo
        Dim objSOP As New SpecialOfferProductsInfo
        Product.OfferID = offerID
        Product.ProductID = 0
        Product.Quantity = 0
        Product.CategoryID = ddlCategory.SelectedValue
        Product.Type = "B"
        Product.Type2 = BonusType
        '  objSOP.CategoryName = ddlCategoryList.CategoryName
        objSPC.AddSpecialOfferProducts(Product)
        Select Case BonusType
            Case BonusType.GiveDiscount
                BindDiscountProducts()
            Case BonusType.OfferFreeShipping
                BindFreeShippingProducts()
        End Select


    End Sub

    Protected Sub btnDeleteProducts_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnDeleteDiscountProducts.Click
        Dim objSPC As New SpecialOfferController
        For Each row As GridViewRow In gvDiscountProducts.Rows
            Dim cbSelect As CheckBox = CType(row.Cells(0).FindControl("cbSelect"), CheckBox)
            If cbSelect.Checked Then
                Dim hfCategoryID As HiddenField = CType(row.FindControl("hfCategoryID"), HiddenField)
                Dim hfProductID As HiddenField = CType(row.FindControl("hfProductID"), HiddenField)
                objSPC.DeleteSpecialOfferProducts(hfOfferID.Value, hfProductID.Value, hfCategoryID.Value, "B", BonusType)
            End If
        Next
        BindData()
    End Sub
    Protected Sub btnDeleteFreeShipping_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnDeleteFreeShipping.Click
        Dim objSPC As New SpecialOfferController
        For Each row As GridViewRow In gvFreeShippingProducts.Rows
            Dim cbSelect As CheckBox = CType(row.Cells(0).FindControl("cbSelect"), CheckBox)
            If cbSelect.Checked Then
                Dim hfCategoryID As HiddenField = CType(row.FindControl("hfCategoryID"), HiddenField)
                Dim hfProductID As HiddenField = CType(row.FindControl("hfProductID"), HiddenField)
                objSPC.DeleteSpecialOfferProducts(hfOfferID.Value, hfProductID.Value, hfCategoryID.Value, "B", BonusType)
            End If
        Next

        BindData()

    End Sub
    Protected Sub btnDeleteSpecialPrice_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnDeleteSpecialPrice.Click

        Dim objSPC As New SpecialOfferController

        For Each row As GridViewRow In gvSpecailPriceProducts.Rows
            Dim cbSelect As CheckBox = CType(row.FindControl("cbSelect"), CheckBox)
            If cbSelect.Checked Then
                Dim hfProductID As HiddenField = CType(row.FindControl("hfProductID"), HiddenField)
                objSPC.DeleteSpecailOffersBonusPrice(hfOfferID.Value, hfProductID.Value)
            End If
        Next
        BindData()

    End Sub


    Protected Sub gvCertainProducts_RowDataBound(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.GridViewRowEventArgs) Handles gvDiscountProducts.RowDataBound
        If e.Row.RowType = DataControlRowType.DataRow Then
            Dim lbProductName As Label = CType(e.Row.FindControl("lbProductName"), Label)
            Dim lbCategoryName As Label = CType(e.Row.FindControl("lbCategoryName"), Label)
            If lbCategoryName.Text.Length > 0 Then
                lbCategoryName.Visible = True
                lbProductName.Visible = False
                lbCategoryName.Text = String.Format("[еƷ]{0}", lbCategoryName.Text)
            Else
                lbCategoryName.Visible = False
                lbProductName.Visible = True
                lbProductName.Text = String.Format("[Ʒ]{0}", lbProductName.Text)
            End If


        End If
    End Sub
    Protected Sub gvFreeShippingProducts_RowDataBound(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.GridViewRowEventArgs) Handles gvFreeShippingProducts.RowDataBound
        If e.Row.RowType = DataControlRowType.DataRow Then
            Dim lbProductName As Label = CType(e.Row.FindControl("lbProductName"), Label)
            Dim lbCategoryName As Label = CType(e.Row.FindControl("lbCategoryName"), Label)
            If lbCategoryName.Text.Length > 0 Then
                lbCategoryName.Visible = True
                lbProductName.Visible = False
                lbCategoryName.Text = String.Format("[еƷ]{0}", lbCategoryName.Text)
            Else
                lbCategoryName.Visible = False
                lbProductName.Visible = True
                lbProductName.Text = String.Format("[Ʒ]{0}", lbProductName.Text)
            End If

        End If
    End Sub

    Protected Sub btnUpdateSpecialPrice_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnUpdateSpecialPrice.Click


        Dim objSPC As New SpecialOfferController
        For i As Integer = 0 To gvSpecailPriceProducts.Rows.Count - 1
            Dim row As GridViewRow = gvSpecailPriceProducts.Rows(i)
            Dim txtAdjustPrice As TextBox = CType(row.FindControl("txtAdjustPrice"), TextBox)
            Dim hfProductID As HiddenField = CType(row.FindControl("hfProductID"), HiddenField)
            Dim product As New SpecialOfferBonusPriceInfo(hfOfferID.Value, hfProductID.Value, 0, Decimal.Parse(txtAdjustPrice.Text))
            objSPC.UpdateSpecailOffersBonusPrice(product)
        Next i

        BindData()
        ResultMessageControl1.ShowSuccess("³ɹ!")
    End Sub
    Protected Sub btnUpdateDiscount_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnUpdateDiscount.Click
        Dim objSOC As New SpecialOfferController
        Dim Amount As New SpecialOfferAmountInfo
        Amount.MaxAomount = Decimal.Parse(txtDiscountAmount.Text)
        Amount.DisCountType = IIf(CInt(ddlDiscountType.SelectedValue) = 0, DiscountType.Percent, DiscountType.Absolute)
        Amount.DiscountExceed = Decimal.Parse(txtDiscountExceed.Text)
        Amount.Type = "B"
        Amount.Type2 = BonusType
        Amount.OfferID = hfOfferID.Value
        objSOC.SaveSpecailOffersAmount(Amount)
        BindData()
        ResultMessageControl1.ShowSuccess("³ɹ!")
    End Sub

    Protected Sub btnUpdatePoint_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnUpdatePoint.Click
        Dim objSOC As New SpecialOfferController
        Dim Amount As New SpecialOfferAmountInfo
        Amount.MaxAomount = Decimal.Parse(txtMaxPoint.Text)
        Amount.MinAmount = Decimal.Parse(txtMinPoint.Text)
        Amount.Type = "B"
        Amount.Type2 = BonusType
        Amount.OfferID = hfOfferID.Value
        objSOC.SaveSpecailOffersAmount(Amount)
        ResultMessageControl1.ShowSuccess("³ɹ!")
    End Sub

#Region "-------Private Method-------"

    Private Sub BindData()

        Dim IsComplete As Boolean
        Dim BonusText As String = "error"



        Select Case BonusType
            Case SpecialOffer.BonusType.GiveBonusPoint
                pChooseProducts.Visible = False
                IsComplete = BindPiont()
                BonusText = GiveBonusPoint
            Case SpecialOffer.BonusType.GiveCoupon
                pChooseProducts.Visible = False
                BonusText = GiveCoupon
            Case SpecialOffer.BonusType.GiveDiscount
                Dim objSPC As New SpecialOfferController
                BindDiscountProducts()
                pChooseProducts.Visible = True
                IsComplete = BindDiscountAmount()
                BonusText = GIVEDISCOUNT
            Case SpecialOffer.BonusType.OfferFreeShipping
                Dim objSPC As New SpecialOfferController
                IsComplete = BindFreeShippingProducts()
                pChooseProducts.Visible = True
                pChooseProducts.Visible = True
                BonusText = OfferFreeShipping
            Case SpecialOffer.BonusType.OfferMemberShip
                pChooseProducts.Visible = True
                BonusText = OfferMemberShip
            Case SpecialOffer.BonusType.SpecialPrice
                Dim objSPC As New SpecialOfferController
                pChooseProducts.Visible = True
                '  rblProductCategory.Visible = False
                IsComplete = BindSpecailPriceProducts()
                BonusText = SpecialPrice
            Case Else
                pChooseProducts.Visible = False
        End Select

        rblBonuses.Items(0).Text = GIVEDISCOUNT
        rblBonuses.Items(1).Text = SPECIALPRICE
        rblBonuses.Items(2).Text = OFFERFREESHIPPING
        rblBonuses.Items(3).Text = GIVEBONUSPOINT
        If Not IsComplete Then
            hfIsComplete.Value = 0
            rblBonuses.SelectedItem.Text = String.Format("{0}<font color=red >({1})</font>", BonusText, INCOMPLETE)
        Else
            hfIsComplete.Value = 1
        End If
        mvConditions.ActiveViewIndex = rblBonuses.SelectedValue


    End Sub

    Private Function BindDiscountProducts() As Boolean

        Dim products As Generic.List(Of SpecialOfferProductsInfo) = SpecialOfferController.GetSpecialOfferProductsList(hfOfferID.Value, "B", BonusType)
        gvDiscountProducts.DataSource = products
        gvDiscountProducts.DataBind()
        Dim b As Boolean = products.Count > 0
        btnDeleteDiscountProducts.Visible = b
        Dim jString As New StringBuilder
        jString.Append("")
        Return True
    End Function
    Private Function BindPiont() As Boolean

        Dim objSPC As New SpecialOfferController
        Dim objSPA As SpecialOfferAmountInfo = objSPC.GetSpecialOfferAmount(hfOfferID.Value, "B", BonusType)
        Dim b As Boolean
        If Not IsNothing(objSPA) Then
            txtMaxPoint.Text = String.Format("{0:F}", objSPA.MaxAomount)
            txtMinPoint.Text = String.Format("{0:F}", objSPA.MinAmount)
            b = (objSPA.MinAmount > 0.0)
        Else
            txtMaxPoint.Text = "0.00"
            txtMinPoint.Text = "0.00"
            b = False
        End If
        Return b
    End Function
    Private Function BindFreeShippingProducts() As Boolean

        Dim products As Generic.List(Of SpecialOfferProductsInfo) = SpecialOfferController.GetSpecialOfferProductsList(hfOfferID.Value, "B", BonusType)

        gvFreeShippingProducts.DataSource = products
        gvFreeShippingProducts.DataBind()
        Dim b As Boolean = products.Count > 0
        btnDeleteFreeShipping.Visible = b
        Return True
    End Function
    Private Function BindSpecailPriceProducts() As Boolean

        Dim objSPC As New SpecialOfferController
        Dim products As Generic.List(Of SpecialOfferBonusPriceInfo) = objSPC.GetSpecialOfferBonusPriceList(hfOfferID.Value)

        gvSpecailPriceProducts.DataSource = products
        gvSpecailPriceProducts.DataBind()
        Dim b As Boolean = products.Count > 0
        btnUpdateSpecialPrice.Visible = b
        btnDeleteSpecialPrice.Visible = b
        Return b
    End Function
    Private Function BindDiscountAmount() As Boolean
        Dim objSPC As New SpecialOfferController
        Dim objSPA As SpecialOfferAmountInfo = objSPC.GetSpecialOfferAmount(hfOfferID.Value, "B", BonusType)
        Dim b As Boolean
        If Not IsNothing(objSPA) Then
            txtDiscountAmount.Text = String.Format("{0:F}", objSPA.MaxAomount)
            txtDiscountExceed.Text = String.Format("{0:F}", objSPA.DiscountExceed)
            ddlDiscountType.SelectedValue = CInt(objSPA.DisCountType)
            b = (objSPA.MaxAomount > 0.0)
        Else
            txtDiscountAmount.Text = "0.00"
            txtDiscountExceed.Text = "0.00"
            b = False
        End If
        Return b
    End Function


#End Region

    Protected Sub SpecialOfferNavControl1_StepMenuItemClick(ByVal navigateUrl As String) Handles SpecialOfferNavControl1.StepMenuItemClick
        If CBool(hfIsComplete.Value) Then
            My.Response.Redirect(navigateUrl)
        Else
            ResultMessageControl1.ShowFail("ɶԽݵ!")
        End If

    End Sub

    Protected Sub btnGoCondition_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnGoCondition.Click
        'If CBool(hfIsComplete.Value) Then
        Dim navigateUrl As String = "~/Admin/Merchandising/Offers.aspx?mode=editoffer&submode=condition&offerid=" & hfOfferID.Value.ToString
        My.Response.Redirect(navigateUrl)
        'Else
        '  ResultMessageControl1.ShowFail("ɶԽݵ!")
        ' End If
    End Sub

    Protected Sub btnGoPromo_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnGoPromo.Click
        If CBool(hfIsComplete.Value) Then
            Dim navigateUrl As String = "~/Admin/Merchandising/Offers.aspx?mode=editoffer&submode=promotext&offerID=" & hfOfferID.Value.ToString
            My.Response.Redirect(navigateUrl)
        Else
            ResultMessageControl1.ShowFail("ɶԽݵ!")
        End If
    End Sub
End Class
