Imports NetShopForge.Library.Product
Imports NetShopForge.Library.SpecialOffer
Partial Class Admin_Merchandising_Controls_ConditionsControl
    Inherits System.Web.UI.UserControl

    ' Public SpecailOffer As SpecialOffer.SpecialOfferInfo

    Private Const CERTAINPRODUTS As String = "˿͹һ߶ĳƷ"
    Private Const SUBTOTALEXCEED As String = "ܽĳĳ"
    Private Const BONUSPOINT As String = "˿͵ĻԱִﵽĳĳ"
    Private Const INCOMPLETE As String = "δ"


    Public Property ConditionType() As ConditionType
        Get
            Return rblConditons.SelectedValue
        End Get
        Set(ByVal value As ConditionType)
            rblConditons.SelectedValue = value
        End Set
    End Property

    Private Sub BindConditionList()
        rblConditons.Items.Clear()
        rblConditons.Items.Add(New ListItem(CertainProduts, "0"))
        rblConditons.Items.Add(New ListItem(SubtotalExceed, "1"))
        rblConditons.Items.Add(New ListItem(BonusPoint, "3"))
    End Sub



    Protected Sub RadioButtonList1_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles rblConditons.SelectedIndexChanged
        mvConditions.ActiveViewIndex = CInt(rblConditons.SelectedValue)
        Dim objSPC As New SpecialOfferController
        objSPC.UpdateSpecailOfferType(CInt(hfOfferID.Value), "C", CInt(rblConditons.SelectedValue))
        BindData()
    End Sub

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not IsPostBack Then
            Dim offerID As String = Request("offerid")
            If IsNothing(offerID) Then My.Response.Redirect("~/Admin/Merchandising/Offers.aspx")
            hfOfferID.Value = offerID
            Dim so As SpecialOfferInfo
            so = SpecialOfferController.GetSpecialOffer(hfOfferID.Value)
            ConditionType = so.ConditionType
            rblConditons.SelectedValue = ConditionType
            SpecialOfferNavControl1.Enabled = (so.Status <> SpecialOfferStatus.Incomplete)
            BindData()
            NetShopForge.Library.Category.CategoryTree.Instance.SetCategoryList(ddlCategory, "")
        End If
    End Sub



    Protected Sub gvCertainProducts_RowDataBound(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.GridViewRowEventArgs) Handles gvCertainProducts.RowDataBound

        If e.Row.RowType = DataControlRowType.DataRow Then
            Dim lbProductName As Label = CType(e.Row.FindControl("lbProductName"), Label)
            Dim lbCategoryName As Label = CType(e.Row.FindControl("lbCategoryName"), Label)
            If lbCategoryName.Text.Length > 0 Then
                lbCategoryName.Visible = True
                lbProductName.Visible = False
                lbCategoryName.Text = String.Format("[еƷ]{0}", lbCategoryName.Text)
            Else
                lbCategoryName.Visible = False
                lbProductName.Visible = True
                lbProductName.Text = String.Format("[Ʒ]{0}", lbProductName.Text)
            End If
        End If
    End Sub


#Region "----CertainProducts----------"

    Protected Sub ChooseProductsControl1_ProductSelected1(ByVal selectedProducts As System.Collections.Generic.List(Of NetShopForge.Library.Product.ProductSelectedInfo)) Handles ChooseProductsControl1.ProductSelected
        Dim offerID As Integer = CInt(hfOfferID.Value)
        Dim ps As ProductSelectedInfo
        Dim objSPC As New SpecialOfferController
        For Each ps In selectedProducts
            Dim Product As New SpecialOfferProductsInfo
            Product.OfferID = offerID
            Product.ProductID = ps.ProductID
            Product.Quantity = 1
            Product.CategoryID = 0
            Product.Type = "C"
            Product.Type2 = ConditionType
            objSPC.AddSpecialOfferProducts(Product)
        Next
        BindData()

    End Sub
    Protected Sub btnAddCategory_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnAddCategory.Click
        Dim objSPC As New SpecialOfferController
        Dim offerID As Integer = CInt(hfOfferID.Value)
        'objSPC.SaveSpecialOfferProducts(offerID, 0, CategoryListControl1.CategoryID, "C", 1)
        Dim Product As New SpecialOfferProductsInfo
        Product.OfferID = offerID
        Product.ProductID = 0
        Product.Quantity = 1
        Product.CategoryID = ddlCategory.SelectedValue
        Product.Type = "C"
        Product.Type2 = ConditionType
        objSPC.AddSpecialOfferProducts(Product)
        BindData()

    End Sub
    Protected Sub btnDeleteProducts_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnDeleteProducts.Click
        If gvCertainProducts.Rows.Count > 0 Then

            Dim objSPC As New SpecialOfferController

            For Each row As GridViewRow In gvCertainProducts.Rows
                Dim cbSelect As CheckBox = CType(row.Cells(0).FindControl("cbSelect"), CheckBox)
                If cbSelect.Checked Then
                    Dim hfCategoryID As HiddenField = CType(row.FindControl("hfCategoryID"), HiddenField)
                    Dim hfProductID As HiddenField = CType(row.FindControl("hfProductID"), HiddenField)
                    objSPC.DeleteSpecialOfferProducts(hfOfferID.Value, hfProductID.Value, hfCategoryID.Value, "C", ConditionType)
                End If
            Next
            BindData()
        End If
    End Sub

    Protected Sub btnUpdateProducts_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnUpdateProducts.Click


        Dim objSPC As New SpecialOfferController
        For i As Integer = 0 To gvCertainProducts.Rows.Count - 1
            Dim row As GridViewRow = gvCertainProducts.Rows(i)
            Dim txtQty As TextBox = CType(row.FindControl("txtQty"), TextBox)
            Dim hfCategoryID As HiddenField = CType(row.FindControl("hfCategoryID"), HiddenField)
            Dim hfProductID As HiddenField = CType(row.FindControl("hfProductID"), HiddenField)

            Dim product As New SpecialOfferProductsInfo(hfOfferID.Value, hfProductID.Value, hfCategoryID.Value, "C", ConditionType, Integer.Parse(txtQty.Text))
            objSPC.UpdateSpecailOfferProducts(product)

        Next i
        BindData()
        ResultMessageControl1.ShowSuccess("³ɹ!")

    End Sub

#End Region

#Region "-------Private Method-------"
    Private Sub BindData()
        Dim IsComplete As Boolean
        Dim ConditionText As String = "error"
        Select Case ConditionType
            Case ConditionType.BonusPoint
                IsComplete = BindBonusPoint()
                ConditionText = BonusPoint
            Case ConditionType.CertainProduts
                IsComplete = BindCertainProduts()
                ConditionText = CertainProduts
            Case ConditionType.MemberShip
            Case ConditionType.SpecificLocation
            Case ConditionType.SubtotalExceed
                IsComplete = BindSubtotalExceed()
                ConditionText = SubtotalExceed
        End Select

        rblConditons.Items(0).Text = CertainProduts
        rblConditons.Items(1).Text = SubtotalExceed
        rblConditons.Items(2).Text = BonusPoint
        If Not IsComplete Then
            hfIsComplete.Value = 0
            rblConditons.SelectedItem.Text = String.Format("{0}<font color=red >({1})</font>", ConditionText, INCOMPLETE)
        Else
            hfIsComplete.Value = 1
        End If
        mvConditions.ActiveViewIndex = rblConditons.SelectedValue
    End Sub

    Private Function BindCertainProduts() As Boolean

        Dim products As Generic.List(Of SpecialOfferProductsInfo) = SpecialOfferController.GetSpecialOfferProductsList(hfOfferID.Value, "C", CInt(ConditionType))
        gvCertainProducts.DataSource = products
        gvCertainProducts.DataBind()
        Dim b As Boolean = products.Count > 0
        btnDeleteProducts.Visible = b
        btnUpdateProducts.Visible = b
        Return True

    End Function
    Private Function BindSubtotalExceed() As Boolean
        Dim objSOC As New SpecialOfferController
        Dim amount As SpecialOfferAmountInfo
        Dim b As Boolean
        amount = objSOC.GetSpecialOfferAmount(hfOfferID.Value, "C", ConditionType)
        If Not IsNothing(amount) Then
            txtMinSubtotal.Text = String.Format("{0:F}", amount.MinAmount)
            txtMaxSubtotal.Text = String.Format("{0:F}", amount.MaxAomount)
            b = (amount.MinAmount > 0.0)
        Else
            txtMinSubtotal.Text = "0.00"
            txtMaxSubtotal.Text = "0.00"
            b = False
        End If
        Return b
    End Function

    Private Function BindBonusPoint() As Boolean
        Dim objSOC As New SpecialOfferController
        Dim amount As SpecialOfferAmountInfo
        amount = objSOC.GetSpecialOfferAmount(hfOfferID.Value, "C", ConditionType)
        Dim b As Boolean
        If Not IsNothing(amount) Then
            txtMinPoint.Text = String.Format("{0:F}", amount.MinAmount)
            txtMaxPoint.Text = String.Format("{0:F}", amount.MaxAomount)
            b = (amount.MinAmount > 0.0)
        Else
            txtMinPoint.Text = "0.00"
            txtMaxPoint.Text = "0.00"
            b = False
        End If
        Return b
    End Function

#End Region

    Protected Sub btnUpdateSubtotalExceed_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnUpdateSubtotalExceed.Click
        Dim objSOC As New SpecialOfferController
        Dim Amount As New SpecialOfferAmountInfo
        Amount.OfferID = hfOfferID.Value
        Amount.MinAmount = Decimal.Parse(txtMinSubtotal.Text)
        Amount.MaxAomount = Decimal.Parse(txtMaxSubtotal.Text)
        Amount.Type = "C"
        Amount.Type2 = ConditionType
        objSOC.SaveSpecailOffersAmount(Amount)
        BindData()
        ResultMessageControl1.ShowSuccess("³ɹ!")
    End Sub
    Protected Sub btnUpdatePoint_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnUpdatePoint.Click
        Dim objSOC As New SpecialOfferController
        Dim Amount As New SpecialOfferAmountInfo
        Amount.OfferID = hfOfferID.Value
        Amount.MinAmount = Decimal.Parse(txtMinPoint.Text)
        Amount.MaxAomount = Decimal.Parse(txtMaxPoint.Text)
        Amount.Type = "C"
        Amount.Type2 = ConditionType
        objSOC.SaveSpecailOffersAmount(Amount)
        BindData()
        ResultMessageControl1.ShowSuccess("³ɹ!")
    End Sub

    Protected Sub SpecialOfferNavControl1_StepMenuItemClick(ByVal navigateUrl As String) Handles SpecialOfferNavControl1.StepMenuItemClick
        If CBool(hfIsComplete.Value) Then
            My.Response.Redirect(navigateUrl)
        Else
            ResultMessageControl1.ShowFail("ɶ!")
        End If
    End Sub

    Protected Sub btnNext_Click1(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnNext.Click
        If CBool(hfIsComplete.Value) Then
            Dim navString As String = "~/Admin/Merchandising/Offers.aspx?mode=editoffer&submode=bonus&offerID=" & hfOfferID.Value.ToString
            My.Response.Redirect(navString)
        Else
            ResultMessageControl1.ShowFail("ɶ!")
        End If
    End Sub
End Class
