Imports NetShopForge.Library.SpecialOffer
Partial Class Admin_Merchandising_Controls_OfferControl
    Inherits System.Web.UI.UserControl
    '    Public OfferID As Integer

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not IsPostBack Then
            Dim offerID As String = Request("offerid")
            If IsNothing(offerID) Then My.Response.Redirect("~/Admin/Merchandising/Offers.aspx")
            hfOfferID.Value = offerID
            Dim so As SpecialOfferInfo
            so = SpecialOfferController.GetSpecialOffer(hfOfferID.Value)
            SpecialOfferNavControl1.Enabled = (so.Status <> SpecialOfferStatus.Incomplete)
            BindData()
        End If
    End Sub

    Private Sub BindData()
        Dim so As SpecialOfferInfo
        so = SpecialOfferController.GetSpecialOffer(hfOfferID.Value)
        If so.StartDate <> DateTime.MinValue Then dpStartDate.SelectedDate = so.StartDate
        If so.EndData <> DateTime.MinValue Then dpEndDate.SelectedDate = so.EndData

        txtTitle.Text = so.Title
        ddlIsValid.SelectedValue = CInt(so.IsValid)
        ddlIsDisplayShortPromo.SelectedValue = CInt(so.IsDispalyShortPromo)
        If so.StartDate = DateTime.MinValue OrElse so.EndData = DateTime.MinValue Then
            hfIsComplete.Value = 0
        Else
            hfIsComplete.Value = 1
        End If


    End Sub

    Protected Sub btnUpdate_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnUpdate.Click
        Dim objSPC As New SpecialOfferController
        Dim Title As String = txtTitle.Text
        objSPC.UpdateSpecialOffer(hfOfferID.Value, CBool(ddlIsValid.SelectedValue), Title, CBool(ddlIsDisplayShortPromo.SelectedValue), dpStartDate.SelectedDate, dpEndDate.SelectedDate)
        SpecialOfferNavControl1.OfferTitle = Title
        objSPC.UpdateSpecialStatus(hfOfferID.Value)
        ResultMessageControl1.ShowSuccess("³ɹ!")
        BindData()
        SpecialOfferNavControl1.Enabled = True
    End Sub

    Protected Sub SpecialOfferNavControl1_StepMenuItemClick(ByVal navigateUrl As String) Handles SpecialOfferNavControl1.StepMenuItemClick
        If CBool(hfIsComplete.Value) Then
            My.Response.Redirect(navigateUrl)
        Else
            ResultMessageControl1.ShowFail("ɶԻڵ!")
        End If
    End Sub

    Protected Sub btnGoPromo_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnGoPromo.Click
        Dim navigateUrl As String = "~/Admin/Merchandising/Offers.aspx?mode=editoffer&submode=promotext&offerID=" & hfOfferID.Value.ToString
        My.Response.Redirect(navigateUrl)
    End Sub

    Protected Sub btnFinish_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnFinish.Click
        Dim objSPC As New SpecialOfferController
        objSPC.UpdateSpecialStatus(hfOfferID.Value)
        If CBool(hfIsComplete.Value) Then
            Dim navigateUrl As String = "~/Admin/Merchandising/Offers.aspx"
            My.Response.Redirect(navigateUrl)
        Else
            ResultMessageControl1.ShowFail("ɶԻڵ!")
        End If
    End Sub
End Class
