Imports NetShopForge.Library.SpecialOffer
Partial Class Admin_Merchandising_Controls_OfferListControl
    Inherits System.Web.UI.UserControl



    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not IsPostBack Then
            BindData()
        End If
    End Sub

    Private Sub BindData()

        gvSpecialOffers.DataSource = SpecialOfferController.GetSpecialOfferList()
        gvSpecialOffers.DataBind()
    End Sub

    Protected Sub gvSpecialOffers_PageIndexChanging(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.GridViewPageEventArgs) Handles gvSpecialOffers.PageIndexChanging

        gvSpecialOffers.PageIndex = e.NewPageIndex
        BindData()
    End Sub

    Protected Sub gvSpecialOffers_RowDataBound(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.GridViewRowEventArgs) Handles gvSpecialOffers.RowDataBound
        If e.Row.RowType = DataControlRowType.DataRow Then
            Dim hlStatus As HyperLink = CType(e.Row.FindControl("hlStatus"), HyperLink)
            Dim Status As String = ""
            Select Case hlStatus.Text
                Case SpecialOfferStatus.Available.ToString
                    Status = "<font color=green ></font>"
                Case SpecialOfferStatus.Expired.ToString
                    Status = "ѽ"
                Case SpecialOfferStatus.Incomplete.ToString
                    Status = "<font color =red >δ</font>"
                Case SpecialOfferStatus.Upcoming.ToString
                    Status = "<font color=blue >δʼ</font>"
                Case Else
                    Status = "Ч"
            End Select
            hlStatus.Text = Status
        End If
    End Sub

    Protected Sub btnAddNew_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnAddNew.Click
        My.Response.Redirect("~/Admin/Merchandising/Offers.aspx?mode=addoffer")
    End Sub

    Protected Sub btnDelete_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnDelete.Click

        Dim objSOC As New SpecialOfferController
        For i As Integer = 0 To gvSpecialOffers.Rows.Count - 1
            If gvSpecialOffers.Rows(i).RowType = DataControlRowType.DataRow Then
                Dim cbSelect As CheckBox = CType(gvSpecialOffers.Rows(i).FindControl("cbSelect"), CheckBox)
                If cbSelect.Checked Then objSOC.DeleteSpecialOffer(gvSpecialOffers.DataKeys(i).Value)
            End If
        Next i
        BindData()

    End Sub
End Class
