Imports NetShopForge.Library.Product

Partial Class Admin_Product_Controls_ProductAttributeControl
    Inherits System.Web.UI.UserControl


#Region "-------EvemtArgs Method---------"

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load

        If Not IsPostBack Then
            hfProductID.Value = Request("ProductID")
            Dim product As ProductInfo
            product = ProductController.GetProduct(hfProductID.Value)
            BindSelections(Nothing)
            BindAttList(product.ProductAttributeCollection)
            LoadAttributeTemplates()
        End If
    End Sub

    Protected Sub btnAddSection_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnAddSection.Click
        'create an attribute list
        Dim aList As ArrayList = GetSelections()
        If aList Is Nothing Then
            aList = New ArrayList()
        End If

        'create a new selection and add it
        Dim sel As ProductAttributeSelection = New ProductAttributeSelection()
        If txtPriceAdjustment.Text.Length = 0 Then txtPriceAdjustment.Text = "0"

        sel.PriceAdjustment = Decimal.Parse(txtPriceAdjustment.Text)

        sel.Value = txtSelectionAdd.Text
        sel.ItemOrder = aList.Count * 10

        aList.Add(sel)
        aList.Sort()
        BindSelections(aList)

        txtSelectionAdd.Text = ""
        txtPriceAdjustment.Text = ""

    End Sub

    Protected Sub btnSetTemplate_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnSetTemplate.Click

        Dim atc As New ProductAttributeTemplateController
        Dim template As ProductAttributeTemplateInfo = atc.GetProductAttributeTemplate(CInt(ddlAttTemplates.SelectedValue))

        txtAttributeNew.Text = template.AttributeName
        txtAttNewDesc.Text = template.Description
        ddlAttNewSelectionType.SelectedValue = CInt(template.AttributeType)
        Dim attributes As ProductAttributeCollection = CType(NetShopForge.Common.Utility.XmlToObject(GetType(ProductAttributeCollection), template.SelectionList), ProductAttributeCollection)
        Dim AttributeInfo As ProductAttributeInfo = attributes.Item(0)

        Dim aList As New ArrayList
        'create a new selection and add it
        If Not IsNothing(AttributeInfo.Selections) Then
            For Each sel As ProductAttributeSelection In AttributeInfo.Selections
                aList.Add(sel)
            Next
        End If
        BindSelections(aList)
        btnClose.Visible = False
        btnAddAttribute.Text = "µѡ"
        hfEditIndex.Value = "-1"
    End Sub

    Protected Sub btnAddAttribute_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnAddAttribute.Click

        Dim objAttributeInfo As ProductAttributeInfo = New ProductAttributeInfo
        objAttributeInfo.Name = txtAttributeNew.Text.Trim
        objAttributeInfo.Description = txtAttNewDesc.Text.Trim
        objAttributeInfo.SelectionType = CType(Integer.Parse(ddlAttNewSelectionType.SelectedValue), ProductAttributeType)

        'get the selections from the viewstate
        Dim aList As ArrayList = GetSelections()
        If Not IsNothing(aList) Then
            objAttributeInfo.Selections = New System.Collections.Generic.List(Of ProductAttributeSelection)

            If objAttributeInfo.SelectionType <> ProductAttributeType.UserInput Then
                Dim i As Integer = 0
                Do While i < aList.Count
                    objAttributeInfo.Selections.Add(CType(aList(i), ProductAttributeSelection))
                    i += 1
                Loop
            Else
                Dim sel As ProductAttributeSelection = New ProductAttributeSelection
                sel.Value = ""
                sel.PriceAdjustment = 0
                objAttributeInfo.Selections.Add(sel)
            End If

        End If

        'a product can have one or more attribute selections
        'like "size" and "color"
        'store these into the viewstate as they are saved
        'and synch them with the product bits as well
        Dim AttributeCollecion As ProductAttributeCollection = Nothing
        If ViewState("AttributeCollecion") Is Nothing Then
            AttributeCollecion = New ProductAttributeCollection
        Else
            AttributeCollecion = CType(ViewState("AttributeCollecion"), ProductAttributeCollection)
        End If


        If hfEditIndex.Value = "-1" Then
            objAttributeInfo.ItemOrder = AttributeCollecion.Count * 10
            AttributeCollecion.Add(objAttributeInfo)
            AttributeCollecion.Sort()
            txtAttNewDesc.Text = ""
            txtAttributeNew.Text = ""
            ddlAttNewSelectionType.SelectedIndex = 0
            'pnlSelections.Visible = True

            ViewState.Remove("aList")
            BindSelections(Nothing)
        Else
            objAttributeInfo.ItemOrder = AttributeCollecion.Item(hfEditIndex.Value).ItemOrder
            AttributeCollecion.RemoveAt(CInt(hfEditIndex.Value))
            AttributeCollecion.Insert(hfEditIndex.Value, objAttributeInfo)
            AttributeCollecion.Sort()
        End If

        'and set it to the product, which will serialize it down
        'to XML
        ProductController.UpdateProductAttributes(Integer.Parse(hfProductID.Value), AttributeCollecion)

        'bind up the grid
        BindAttList(AttributeCollecion)



    End Sub

    Protected Sub btnSaveAttTemplate_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnSaveAttTemplate.Click
        Dim att As New ProductAttributeInfo
        Dim atts As New ProductAttributeCollection
        Dim attributeTemplate As New ProductAttributeTemplateInfo
        attributeTemplate.AttributeName = txtAttributeNew.Text.Trim()
        attributeTemplate.AttributeType = Integer.Parse(ddlAttNewSelectionType.SelectedValue)
        Dim aList As ArrayList = GetSelections()
        If Not aList Is Nothing Then
            If aList.Count > 0 Then
                att.Selections = New System.Collections.Generic.List(Of ProductAttributeSelection)
                Dim i As Integer = 0
                Do While i < aList.Count
                    att.Selections.Add(CType(aList(i), ProductAttributeSelection))
                    i += 1
                Loop
            End If
        End If
        atts.Add(att)
        attributeTemplate.SelectionList = atts.ToXML
        attributeTemplate.Description = txtAttNewDesc.Text.Trim()
        lblTemplateSaved.Text = "&nbsp;Template Saved"
        Dim objATC As New ProductAttributeTemplateController
        objATC.AddProductAttributeTemplate(attributeTemplate)
        LoadAttributeTemplates()
    End Sub

    'Protected Sub ddlAttNewSelectionType_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles ddlAttNewSelectionType.SelectedIndexChanged
    '    pnlSelections.Visible = ddlAttNewSelectionType.SelectedValue <> "2"
    'End Sub




    Protected Sub gvAttributes_RowEditing(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.GridViewEditEventArgs) Handles gvAttributes.RowEditing

        If ViewState("AttributeCollecion") Is Nothing Then Exit Sub
        Dim AttributeCollecion As ProductAttributeCollection = CType(ViewState("AttributeCollecion"), ProductAttributeCollection)
        hfEditIndex.Value = e.NewEditIndex
        Dim AttributeInfo As ProductAttributeInfo = AttributeCollecion.Item(hfEditIndex.Value)

        Dim aList As New ArrayList
        'create a new selection and add it
        If Not IsNothing(AttributeInfo.Selections) Then
            For Each sel As ProductAttributeSelection In AttributeInfo.Selections
                aList.Add(sel)
            Next
        End If

        txtAttNewDesc.Text = AttributeInfo.Description
        txtAttributeNew.Text = AttributeInfo.Name
        ddlAttNewSelectionType.SelectedValue = AttributeInfo.SelectionType
        BindSelections(aList)

        btnAddAttribute.Text = ""
        btnClose.Visible = True

    End Sub

    Protected Sub btnUpdateSection_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnUpdateSection.Click

        Dim aList As New ArrayList
        For Each row As GridViewRow In gvSections.Rows

            Dim txtSelection As TextBox = CType(row.Cells(1).FindControl("txtSelection"), TextBox)
            Dim txtPriceAdjustment As TextBox = CType(row.Cells(2).FindControl("txtPriceAdjustment"), TextBox)
            Dim txtItemOrder As TextBox = CType(row.Cells(3).FindControl("txtItemOrder"), TextBox)
            Dim sel As New ProductAttributeSelection
            If txtPriceAdjustment.Text.Length = 0 Then txtPriceAdjustment.Text = "0"
            sel.PriceAdjustment = Decimal.Parse(txtPriceAdjustment.Text)
            sel.Value = txtSelection.Text
            sel.ItemOrder = txtItemOrder.Text
            aList.Add(sel)
            aList.Sort()
        Next row
        BindSelections(aList)

    End Sub

    Protected Sub btnDeleteSection_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnDeleteSection.Click

        Dim aList As ArrayList = GetSelections()
        Dim c As New Collection

        For Each row As GridViewRow In gvSections.Rows

            Dim cbSelect As CheckBox = CType(row.Cells(0).FindControl("cbSelect"), CheckBox)
            If cbSelect.Checked Then
                If Not aList Is Nothing Then
                    c.Add(CType(aList(row.RowIndex), ProductAttributeSelection))
                End If
            End If

        Next row

        For i As Integer = 1 To c.Count
            aList.Remove(CType(c.Item(i), ProductAttributeSelection))
        Next i
        BindSelections(aList)

    End Sub


    Protected Sub btnDeleteAttribute_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnDeleteAttribute.Click

        If Not ViewState("AttributeCollecion") Is Nothing Then
            Dim AttributeCollecion As ProductAttributeCollection = CType(ViewState("AttributeCollecion"), ProductAttributeCollection)
            Dim c As New Collection
            For Each row As GridViewRow In gvAttributes.Rows
                Dim cbSelect As CheckBox = CType(row.Cells(0).FindControl("cbSelect"), CheckBox)
                If cbSelect.Checked Then
                    c.Add(CType(AttributeCollecion.Item(row.RowIndex), ProductAttributeInfo))

                End If
            Next
            For i As Integer = 1 To c.Count
                AttributeCollecion.Remove(CType(c.Item(i), ProductAttributeInfo))
            Next i


            'update the product
            ProductController.UpdateProductAttributes(Integer.Parse(hfProductID.Value), AttributeCollecion)
            BindAttList(AttributeCollecion)
        End If
    End Sub

    Protected Sub btnClose_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnClose.Click
        txtAttNewDesc.Text = ""
        txtAttributeNew.Text = ""
        ddlAttNewSelectionType.SelectedIndex = 0
        'pnlSelections.Visible = True

        ViewState.Remove("aList")
        BindSelections(Nothing)
        btnClose.Visible = False
        btnAddAttribute.Text = "µѡ"
        hfEditIndex.Value = "-1"
    End Sub

#End Region

#Region "---Private Method----"
 
    Private Sub BindAttList(ByVal ProductAttributeCollection As ProductAttributeCollection)

        ViewState("AttributeCollecion") = ProductAttributeCollection

        gvAttributes.DataSource = ProductAttributeCollection
        gvAttributes.DataBind()
        Dim b As Boolean = gvAttributes.Rows.Count > 0

        btnDeleteAttribute.Visible = b
        btnUpdateSort.Visible = b

    End Sub

    Private Function GetSelections() As ArrayList
        Dim aList As ArrayList = Nothing
        If Not ViewState("aList") Is Nothing Then
            aList = CType(ViewState("aList"), ArrayList)
        End If
        Return aList
    End Function

    Private Function GetAttributeCollecion() As ProductAttributeCollection
        Dim AttributeCollecion As ProductAttributeCollection = Nothing
        If Not ViewState("AttributeCollecion") Is Nothing Then
            AttributeCollecion = CType(ViewState("AttributeCollecion"), ProductAttributeCollection)
        End If
        Return AttributeCollecion
    End Function

    Private Sub BindSelections(ByVal aList As ArrayList)

        ViewState("aList") = aList

        gvSections.DataSource = aList
        gvSections.DataBind()
        Dim b As Boolean = gvSections.Rows.Count > 0
        btnUpdateSection.Visible = b
        btnDeleteSection.Visible = b
    End Sub

    Private Sub LoadAttributeTemplates()
        Dim atc As New ProductAttributeTemplateController
        ddlAttTemplates.DataSource = atc.GetProductAttributeTemplateList
        ddlAttTemplates.DataTextField = "AttributeName"
        ddlAttTemplates.DataValueField = "ProductAttributeID"
        ddlAttTemplates.DataBind()
    End Sub
#End Region

  
    Protected Sub btnUpdateSort_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnUpdateSort.Click
        Dim AttributeCollecion As ProductAttributeCollection
        AttributeCollecion = CType(ViewState("AttributeCollecion"), ProductAttributeCollection)
        For Each row As GridViewRow In gvAttributes.Rows

            Dim txtItemOrder As TextBox = CType(row.Cells(3).FindControl("txtItemOrder"), TextBox)
            AttributeCollecion.Item(row.RowIndex).ItemOrder = txtItemOrder.Text
        Next row
        AttributeCollecion.Sort()
        BindAttList(AttributeCollecion)
        ProductController.UpdateProductAttributes(Integer.Parse(hfProductID.Value), AttributeCollecion)
    End Sub
End Class
