Imports NetShopForge.Library.Category
Imports NetShopForge.Library.Product

Partial Class Admin_Product_Controls_ProductCategorysControl
    Inherits System.Web.UI.UserControl



    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not IsPostBack Then
            hfProductID.Value = Request("ProductID")
            CategoryTree.Instance.SetCategoryList(lbCategory)
            BindData()
            Dim catID As Integer = ProductController.GetCategoryIDByProductID(hfProductID.Value)
            lblCategory.Text = String.Format("{0}", CategoryController.GetCategoryFullName(catID))

        End If
    End Sub

    Private Sub BindData()
        Dim cList As Generic.List(Of Integer) = Product.ProductController.GetProductCategoryList(CInt(hfProductID.Value))
        Dim cID As Integer
        lbProductCategory.Items.Clear()
        For Each cID In cList
            lbProductCategory.Items.Add(New ListItem(lbCategory.Items.FindByValue(cID).Text, cID))
        Next
    End Sub

    Protected Sub btnAdd_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnAdd.Click
        Dim l As ListItem
        For Each l In lbCategory.Items
            If l.Selected And (Not IsExist(l.Value)) Then
                lbProductCategory.Items.Add(l)
  
                ProductController.AddProductCategory(hfProductID.Value, l.Value)
            End If
        Next
        BindData()
    End Sub

    Private Function IsExist(ByVal categoryID As Integer) As Boolean

        Return Not IsNothing(lbProductCategory.Items.FindByValue(categoryID))

    End Function


    Protected Sub btnDelete_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnDelete.Click
        Dim l As ListItem
        For Each l In lbProductCategory.Items
            If l.Selected Then

                ProductController.DeleteProductCategory(hfProductID.Value, l.Value)
            End If
        Next
        BindData()
    End Sub
End Class
