
Imports NetShopForge.Library.Product
Imports NetShopForge.Library.Shop

Partial Class Admin_Product_Controls_ProductControl
    Inherits System.Web.UI.UserControl


    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load

        If Not IsPostBack Then
            hfSearchText.Value = ""
            BindSearch()
            BindData()
        End If
    End Sub

    Private Sub BindSearch()
        'bind category type
        Category.CategoryTree.Instance.SetCategoryList(ddlCategory, "ȫ")
        '
        'bind Produt type
        ddlShop.Items.Clear()
        ddlShop.Items.Add(New ListItem("ȫ", -1))
        For Each shop As Shop.ShopInfo In ShopController.Instance.GetShops
            ddlShop.Items.Add(New ListItem(shop.ShopName, shop.ShopID))
        Next
    End Sub

    Public Function getShopNameByID(ByVal shopID As String) As String
        Return ShopController.Instance.GetShopName(shopID)

    End Function

    Private Sub BindData()

        Dim totalRecords As Integer = 0
        Dim SearchText As String = hfSearchText.Value

        Dim producList As Generic.List(Of ProductInfo)
        Dim sqlWhere As String = ""
        If SearchText.Trim().Length <> 0 Then
            SearchText = SearchText.Replace("*", "%")
            SearchText = SearchText.Replace("?", "_")
            sqlWhere = String.Format("LOWER({1}) LIKE '{0}'", SearchText.ToLower.Replace("'", "''"), ddlSearch.SelectedValue)
        End If
        Dim strAND As String = ""
        If sqlWhere.Length > 0 Then strAND = " And "

        If ddlShop.SelectedIndex > 0 Then
            sqlWhere += strAND & "SHOPID=" & ddlShop.SelectedValue
        End If

        For i As Integer = 0 To cbSearchList.Items.Count - 1
            If sqlWhere.Length > 0 Then strAND = " And "
            If cbSearchList.Items(i).Selected Then
                Select Case cbSearchList.Items(i).Value
                    Case "IsSpecialOffer"
                        sqlWhere += strAND & "(IsSpecialOffer=1)"
                    Case "IsSellWell"
                        sqlWhere += strAND & "(IsSellWell=1)"
                    Case "IsValid"
                        sqlWhere += strAND & "(IsValid=1)"
                    Case "IsCommend"
                        sqlWhere += strAND & "(IsCommend=1)"
                    Case "IsNewArrival"
                        sqlWhere += strAND & "(IsNewArrival=1)"
                        'Case "zeroStorageQty"
                        '    sqlWhere += strAND & "(StorageQty=0)"
                End Select
            End If
        Next

        If ddlCategory.SelectedValue = -1 Then
            producList = ProductController.GetProductList(Pager.PageSize, Pager.CurrentPageIndex, totalRecords, sqlWhere)
        Else
            producList = ProductController.GetProductList(Pager.PageSize, Pager.CurrentPageIndex, totalRecords, CInt(ddlCategory.SelectedValue), sqlWhere)
        End If

        Pager.RecordCount = totalRecords
        gvProduct.DataSource = producList
        gvProduct.DataBind()
        Pager.CustomInfoHTML = "¼:" + Pager.RecordCount.ToString()
        Pager.CustomInfoHTML += " ҳ:" + Pager.PageCount.ToString()
        Pager.CustomInfoHTML += " ǰҳ:" + Pager.CurrentPageIndex.ToString()

    End Sub

    Protected Sub ChangePage(ByVal src As Object, ByVal e As EventArgs) Handles Pager.PageChanged
        BindData()
    End Sub

    Protected Sub btnSearch_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnSearch.Click
        hfSearchText.Value = txtSearch.Text
        If hfSearchText.Value = "ѯؼ" Then hfSearchText.Value = ""
        Pager.CurrentPageIndex = 1
        BindData()
        txtSearch.Text = ""
        gvProduct.Visible = True
    End Sub

    'Protected Sub gvProduct_RowDataBound(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.GridViewRowEventArgs) Handles gvProduct.RowDataBound
    '    If e.Row.RowType = DataControlRowType.DataRow Then
    '        Dim lbProductType As Label = CType(e.Row.FindControl("lbProductType"), Label)
    '        Dim p() As String = Resources.Enum.ProductType.Split(",")
    '        Dim i As Integer = Integer.Parse(lbProductType.Text)
    '        lbProductType.Text = p(i)
    '    End If
    'End Sub

    Protected Sub btnAddNew_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnAddNew.Click
        My.Response.Redirect("~/Admin/Product/Product.aspx?mode=addnew")
    End Sub

    Protected Sub btnUpdate_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnUpdate.Click
        Try
            Dim r As GridViewRow
            For Each r In gvProduct.Rows
                'Dim quantity As Integer = CType(r.FindControl("txtQuantiy"), TextBox).Text
                ' Dim price As String = CType(r.FindControl("txtPrice"), TextBox).Text
                Dim IsCommend As Boolean = CType(r.FindControl("cbIsCommend"), CheckBox).Checked
                Dim IsNewArrival As Boolean = CType(r.FindControl("cbIsNewArrival"), CheckBox).Checked
                Dim IsSpecialOffer As Boolean = CType(r.FindControl("cbIsSpecialOffer"), CheckBox).Checked
                Dim IsSellWell As Boolean = CType(r.FindControl("cbIsSellWell"), CheckBox).Checked
                Dim IsValid As Boolean = CType(r.FindControl("cbIsValid"), CheckBox).Checked
                Dim ItemOrder As Integer = CType(r.FindControl("txtItemOrder"), TextBox).Text
                Dim productID As Integer = gvProduct.DataKeys(r.RowIndex).Value
                Product.ProductController.UpdataProductQuick(productID, IsSpecialOffer, IsSellWell, IsValid, IsNewArrival, IsCommend, ItemOrder)
            Next

            BindData()
            ResultMessageControl1.ShowSuccess("³ɹ")
        Catch ex As Exception
            ResultMessageControl1.ShowSuccess("ʧܣ" & ex.Message)
        End Try

    End Sub


    Protected Sub btnDelete_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnDelete.Click
        Try
            Dim r As GridViewRow
            For Each r In gvProduct.Rows
              
                Dim productID As Integer = gvProduct.DataKeys(r.RowIndex).Value
                Product.ProductController.DeleteProduct(productID)
            Next

            BindData()
            ResultMessageControl1.ShowSuccess("ɾɹ")
        Catch ex As Exception
            ResultMessageControl1.ShowSuccess("ɾʧܣ" & ex.Message)
        End Try
    End Sub
End Class
