Imports NetShopForge.Library.Product
Partial Class Admin_Product_Controls_ProductDescriptorsControl
    Inherits System.Web.UI.UserControl



    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load

        If Not IsPostBack Then
            hfProductID.Value = Request("ProductID")
            LoadDescriptors()
        End If

    End Sub


    Private Sub LoadDescriptors()
        rptDescriptors.DataSource = ProductController.GetDescriptorList(Integer.Parse(hfProductID.Value))
        rptDescriptors.DataBind()

    End Sub

    Protected Sub btnSaveDescriptor_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnSaveDescriptor.Click
        'add in the new desc list

        Dim pd As ProductDescriptorInfo = New ProductDescriptorInfo
        Try
            pd.ItemOrder = Integer.Parse(txtDescriptorListOrder.Text)
        Catch
        End Try

        pd.ProductID = CInt(hfProductID.Value)
        pd.Title = txtDescriptorTitle.Text
        pd.Descriptor = txtDescriptor.Text
        pd.IsBulletedList = chkIsBulletedList.Checked
        pd.ProductID = Integer.Parse(hfProductID.Value)
        pd.IsValid = True

        ProductController.AddProductDescriptor(pd)

        LoadDescriptors()

    End Sub

    Protected Sub rptDescriptors_ItemCommand(ByVal source As Object, ByVal e As System.Web.UI.WebControls.RepeaterCommandEventArgs) Handles rptDescriptors.ItemCommand
        If Not e.CommandArgument Is Nothing Then

            Dim descriptorID As Integer = Convert.ToInt16(e.CommandArgument.ToString())

            If e.CommandName = "Save" Then
                'update the text and checkbox
                Dim chkIsBulleted As CheckBox = CType(e.Item.FindControl("chkIsBulletedList"), CheckBox)
                Dim chkIsValid As CheckBox = CType(e.Item.FindControl("chkIsValid"), CheckBox)
                Dim txtDesc As FreeTextBoxControls.FreeTextBox = CType(e.Item.FindControl("txtDescriptor"), FreeTextBoxControls.FreeTextBox)
                Dim txtListOrder As TextBox = CType(e.Item.FindControl("txtDescriptorListOrder"), TextBox)
                If Not chkIsBulletedList Is Nothing AndAlso Not txtDescriptor Is Nothing Then
                    Dim pd As ProductDescriptorInfo = New ProductDescriptorInfo()
                    pd.DescriptorID = descriptorID
                    pd.IsBulletedList = chkIsBulleted.Checked
                    pd.Descriptor = txtDesc.Text
                    pd.IsValid = chkIsValid.Checked
                    Try
                        pd.ItemOrder = Integer.Parse(txtListOrder.Text)
                    Catch
                    End Try

                    ProductController.UpdateProductDescriptor(pd)
                End If
            Else
                ProductController.DeleteProductDescriptor(descriptorID)
            End If
            LoadDescriptors()

        End If
    End Sub
End Class
