Imports NetShopForge.Common.nsfImage
Imports NetShopForge.Library.Product
Imports NetShopForge.Common.Globals
Imports NetShopForge.Library.Category
Imports System.IO
Imports NetShopForge.Library.Shop
Imports NetShopForge.Library.Currency
Partial Class Admin_Product_Controls_ProductDetailsControl
    Inherits System.Web.UI.UserControl

    Property objProduct() As ProductInfo
        Get
            Dim p As New ProductInfo
            p.Description = txtDescription.Text
            'p.ListPrice = txtListPrice.Text
            If txtMinOrderAmount.Text.Length = 0 Then
                p.MinOrderAmount = 1
            Else
                p.MinOrderAmount = CInt(txtMinOrderAmount.Text)
            End If
            p.Price = txtPrice.Text
            p.ProductCode = txtProductCode.Text
            p.ProductName = txtProductName.Text
            If txtStorageQty.Text.Length = 0 Then
                p.StorageQty = 0
            Else
                p.StorageQty = CInt(txtStorageQty.Text)
            End If
            If txtStorageQtyLimit.Text.Length = 0 Then
                p.StorageQtyLimit = 0
            Else
                p.StorageQtyLimit = CInt(txtStorageQtyLimit.Text)
            End If
            If txtWeight.Text.Length = 0 Then
                p.Weight = 0
            Else
                p.Weight = CInt(txtWeight.Text)
            End If

            p.IsFreeshipping = CBool(ddlIsFreeShipping.SelectedValue)
            p.IsGlobalDiscounts = CBool(ddlIsGlobalDiscounts.SelectedValue)
            p.IsSellWell = CBool(ddlIsSellWell.SelectedValue)
            p.IsSpecialOffer = CBool(ddlIsSpecialOffer.SelectedValue)
            p.IsValid = CBool(ddlIsValid.SelectedValue)
            p.IsNewArrival = CBool(ddlNewArrival.SelectedValue)
            p.ProductType = CInt(ddlProductType.SelectedValue)
            p.CategoryID = ddlCategory.SelectedValue
            p.Unit = txtUnit.Text
            If hfProductID.Value.Length > 0 Then p.ProductID = CInt(hfProductID.Value)
            p.ManufacturerID = ddlManufacturer.SelectedValue
            p.ProductURL = txtProductURL.Text
            p.InternalShippingFee = txtInternalShippingFee.Text
            p.internationalShippingFee = txtinternationalShippingFee.Text
            p.CurrencyID = ddlCurrency.SelectedValue
            p.AgencyFee = txtAgencyFee.Text


            p.ListPrice = p.AgencyFee + p.InternalShippingFee + p.internationalShippingFee + p.Price


            Return p

        End Get
        Set(ByVal value As ProductInfo)
            txtDescription.Text = value.Description
            '   txtListPrice.Text = String.Format("{0:##.##}", value.ListPrice)
            txtMinOrderAmount.Text = value.MinOrderAmount
            txtPrice.Text = String.Format("{0:##.##}", value.Price)
            txtProductCode.Text = value.ProductCode
            txtProductName.Text = value.ProductName
            txtStorageQty.Text = IIf(value.StorageQty = 0, "", value.StorageQty)
            txtStorageQtyLimit.Text = IIf(value.StorageQtyLimit = 0, "", value.StorageQtyLimit)
            txtWeight.Text = IIf(value.Weight = 0, "", value.Weight)
            txtUnit.Text = value.Unit
            ddlIsFreeShipping.SelectedValue = CInt(value.IsFreeshipping)
            ddlIsGlobalDiscounts.SelectedValue = CInt(value.IsGlobalDiscounts)
            ddlIsSellWell.SelectedValue = CInt(value.IsSellWell)
            ddlIsSpecialOffer.SelectedValue = CInt(value.IsSpecialOffer)
            ddlIsValid.SelectedValue = CInt(value.IsValid)
            ddlNewArrival.SelectedValue = CInt(value.IsNewArrival)
            ddlProductType.SelectedValue = CInt(value.ProductType)
            ddlCategory.SelectedValue = value.CategoryID
            hfProductID.Value = value.ProductID
            ddlManufacturer.SelectedValue = value.ManufacturerID
            ddlCurrency.SelectedValue = value.CurrencyID
            txtAgencyFee.Text = value.AgencyFee
            txtInternalShippingFee.Text = value.InternalShippingFee
            txtinternationalShippingFee.Text = value.internationalShippingFee
            txtProductURL.Text = value.ProductURL


        End Set
    End Property

#Region "---EventArg Method----"

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load

        If Not IsPostBack Then
            hfProductID.Value = Request("productid")
            BindManufacturer()

            BindShop()
            BindCurrency()
            CategoryTree.Instance.SetCategoryList(ddlCategory, "ѡƷ")
            If hfProductID.Value <> "" Then
                objProduct = ProductController.GetProduct(CInt(hfProductID.Value))
            End If


        End If

    End Sub
    Protected Sub btnSave_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnSave.Click
        If hfProductID.Value = "" Then
            hfProductID.Value = ProductController.AddProduct(objProduct)
            ResultMessageControl1.ShowSuccess("Ʒɹ")
            My.Response.Redirect("~/Admin/Product/Product.aspx?mode=details&productid=" & hfProductID.Value.ToString)
        Else
            ProductController.UpdateProduct(objProduct)
            ResultMessageControl1.ShowSuccess("Ʒɹ")
        End If
    End Sub

#End Region
#Region "---Private Method---"

    Private Sub BindManufacturer()
        Dim bc As New NetShopForge.Library.Brand.BrandController
        ddlManufacturer.DataTextField = "Brand"
        ddlManufacturer.DataValueField = "BrandID"
        ddlManufacturer.DataSource = bc.GetBrandList
        ddlManufacturer.DataBind()

    End Sub

    Private Sub BindShop()
        ddlShop.DataTextField = "ShopName"
        ddlShop.DataValueField = "ShopID"
        ddlShop.DataSource = ShopController.Instance.GetShops
        ddlShop.DataBind()
        ddlShop.Items.Insert(0, New ListItem("Ӫ", 0))

    End Sub

    Private Sub BindCurrency()
        ddlCurrency.DataTextField = "Code"
        ddlCurrency.DataValueField = "CurrencyID"
        ddlCurrency.DataSource = CurrencyController.Instance.GetCurrencyList
        ddlCurrency.DataBind()
    End Sub


#End Region


End Class
