Imports NetShopForge.Library.Product
Partial Class Admin_Product_Controls_ProductFeedBackControl
    Inherits System.Web.UI.UserControl

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not IsPostBack Then
            hfReviewID.Value = Request("reviewid")
            BindData()
        End If
    End Sub


    Private Sub BindData()
        Dim r As ProductReviewInfo = ProductReviewController.GetProductReview(CInt(hfReviewID.Value))
        UserID.Text = r.UserID
        ProductName.Text = r.ProductName
        ReviewerName.Text = r.ReviewerName & IIf(r.Location.ToString.Length = 0, "", String.Format("({0})", r.Location))
        ReviewDate.Text = String.Format("{0:f}", r.ReviewDate)
        Comments.Text = r.Comments
        txtFeedBack.Text = r.FeedBack
        Title.Text = r.Title
        rvRating.DisplayValue = r.Rating
        ddlIsApproved.SelectedValue = CInt(r.IsApproved)
    End Sub

    Protected Sub btnSave_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnSave.Click
        ProductReviewController.UpdateProductReview(CInt(hfReviewID.Value), CBool(ddlIsApproved.SelectedValue), txtFeedBack.Text)
    End Sub
End Class
