Imports NetShopForge.Library.Product
Imports NetShopForge.Common.nsfImage
Partial Class Admin_Product_Controls_ProductImageControl
    Inherits System.Web.UI.UserControl


  

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not IsPostBack Then
            hfProductID.Value = Request("productid")
            If hfProductID.Value.Length > 0 Then
                txtCaption.Text = ProductController.GetProduct(CInt(hfProductID.Value)).ProductName
            End If

            BindImage(hfProductID.Value)

            BindMultipleView(hfProductID.Value)
        End If
    End Sub

    Protected Sub btnAddImage_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnAddImage.Click

        Dim ic As New ProductImageController
        Try
            Dim productID As Integer = CInt(hfProductID.Value)

            Dim sOK As String

            Dim pi As New ProductImageInfo
            pi.Type = CInt(ddlImageType.SelectedValue)
            pi.ProductID = productID
            SetPathAndName(pi.Type, pi.SavePath, pi.SaveName)
            pi.SaveName = pi.SaveName & productID.ToString
            If pi.Type = ProductImageType.MultipleView Then
                pi.SaveName = pi.SaveName & "_" & NetShopForge.Common.Utility.GetRandomString()
            End If
            pi.ImagePath = pi.SavePath.Replace("\", "/") & "/" & pi.SaveName & System.IO.Path.GetExtension(FileUploadImage.PostedFile.FileName).ToLower
            pi.Caption = txtCaption.Text


            sOK = UploadImage(pi)

            If sOK.Length = 0 Then
                ic.AddProductImage(pi)
            Else
                ResultMessageControl1.ShowFail("ͼƬʧ!(" & sOK & ")")
                Exit Sub
            End If

            If cbThumbnail.Checked And pi.Type = ProductImageType.Normal Then


                Dim pti As New ProductImageInfo
                pti.Type = ProductImageType.Thumbnail
                pti.ProductID = productID
                SetPathAndName(ProductImageType.Thumbnail, pti.SavePath, pti.SaveName)
                pti.SaveName = pti.SaveName & productID.ToString
                pti.ImagePath = pti.SavePath.Replace("\", "/") & "/" & pti.SaveName & System.IO.Path.GetExtension(FileUploadImage.PostedFile.FileName).ToLower
                pti.Caption = txtCaption.Text
                pti.Width = txtThumbWidth.Text

                pti.Height = txtThumbWidth.Text
                sOK = UploadImage(pti)
                If sOK.Length = 0 Then
                    ic.AddProductImage(pti)
                    ic.UpdateImagepath(productID, pti.ImagePath)
                Else
                    ResultMessageControl1.ShowFail("ͼƬʧ!(" & sOK & ")")
                    Exit Sub
                End If

            End If

            If pi.Type = ProductImageType.MultipleView Then
                BindMultipleView(productID)
            Else
                BindImage(productID)
            End If

            ResultMessageControl1.ShowSuccess("ͼƬɹ!")
        Catch ex As Exception
            ResultMessageControl1.ShowFail("ͼƬʧ!" & ex.Message)
        End Try
   


    End Sub



    Private Function UploadImage(ByVal productImage As ProductImageInfo) As String

        Dim objIC As New ImageController
        If productImage.Width = 0 Then
            Return objIC.UploadImage(FileUploadImage.PostedFile, productImage.SavePath, productImage.SaveName)
        Else
            Return objIC.UploadImage(FileUploadImage.PostedFile, productImage.SavePath, productImage.SaveName, productImage.Width, productImage.Height)
        End If

    End Function

    Private Sub SetPathAndName(ByVal type As ProductImageType, ByRef path As String, ByRef name As String)
        Select Case type
            Case ProductImageType.MultipleView
                path = "Image_Shop\Products\m"
                name = "M"
            Case ProductImageType.Normal
                path = "Image_Shop\Products\n"
                name = "N"
            Case ProductImageType.Thumbnail
                path = "Image_Shop\Products\t"
                name = "T"
        End Select
    End Sub


    Private Sub BindImage(ByVal productID As Integer)

        Dim ic As New ProductImageController
        Dim normalImage, thumbnailImage As Generic.List(Of ProductImageInfo)
        normalImage = ic.GetProductImageList(productID, ProductImageType.Normal)
        thumbnailImage = ic.GetProductImageList(productID, ProductImageType.Thumbnail)

        If normalImage.Count > 0 Then
            Dim s As New StringBuilder
            s.Append(String.Format("<b>{0}</b>", "׼ͼƬ(鿴ԭͼ)"))
            s.Append(String.Format("<br/> <a target=""_blank"" href=""{0}"">", Page.ResolveUrl("~/" & normalImage.Item(0).ImagePath & "?temp=" + DateTime.Now.Ticks.ToString())))
            s.Append(String.Format("<img src=""{0}""  border=0 title=""{1}"" />  </a>", Page.ResolveUrl("~/IHttpHandler/ImageHandler.ashx?ImagePath=~/" & normalImage.Item(0).ImagePath & "&size=120,120&temp=" + DateTime.Now.Ticks.ToString()), normalImage.Item(0).Caption))
            NormalImageText.Text = s.ToString
        End If
        If thumbnailImage.Count > 0 Then
            Dim s As New StringBuilder
            s.Append(String.Format("<b>{0}</b>", "ͼ"))
            s.Append(String.Format("<br/> <a target=""_blank"" href=""{0}"">", Page.ResolveUrl("~/" & thumbnailImage.Item(0).ImagePath & "?temp=" + DateTime.Now.Ticks.ToString())))
            s.Append(String.Format("<img src=""{0}""  border=0  title=""{1}""  /></a>", Page.ResolveUrl("~/IHttpHandler/ImageHandler.ashx?ImagePath=~/" & thumbnailImage.Item(0).ImagePath & "&size=120,120&temp=" + DateTime.Now.Ticks.ToString()), thumbnailImage.Item(0).Caption))


            ThumbnailImageText.Text = s.ToString
        End If

       
    End Sub

    Private Sub BindMultipleView(ByVal productID As Integer)
        Dim ic As New ProductImageController
        dlMultipleView.DataSource = ic.GetProductImageList(productID, ProductImageType.MultipleView)
        dlMultipleView.DataBind()
    End Sub

    Protected Sub btnDelete_Click(ByVal sender As Object, ByVal e As System.EventArgs)
        Dim pc As New ProductImageController
        pc.DeleteProductImage(CInt(CType(sender, Button).CommandArgument))
        BindMultipleView(Cint(hfProductID.Value))
    End Sub

  
End Class
