Imports NetShopForge.Library.Product

Partial Class Admin_Product_Controls_ProductLinksControl
    Inherits System.Web.UI.UserControl

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not IsPostBack Then
            hfProductID.Value = Request("productid")
            BindData()
        End If
    End Sub


    Private Sub BindData()
        gvProductLinks.DataSource = ProductController.GetProductLinksList(CInt(hfProductID.Value))
        gvProductLinks.DataBind()
    End Sub


    Protected Sub btnDelete_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnDelete.Click


        For Each row As GridViewRow In gvProductLinks.Rows
            Dim cbSelect As CheckBox = CType(row.Cells(0).FindControl("cbSelect"), CheckBox)
            If cbSelect.Checked Then
                Dim linkID As Integer = CInt(gvProductLinks.DataKeys(row.RowIndex).Value)
                ProductController.DeleteProductLinks(linkID)
            End If
        Next

        BindData()

    End Sub

    Protected Sub btnUpdate_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnUpdate.Click

        For Each row As GridViewRow In gvProductLinks.Rows

            Dim ddlLinkType As DropDownList = CType(row.FindControl("ddlLinkType"), DropDownList)
            Dim linkID As Integer = CInt(gvProductLinks.DataKeys(row.RowIndex).Value)
            ProductController.UpdateProductLinks(linkID, ddlLinkType.SelectedValue)
        Next row

        BindData()

    End Sub

    Protected Sub ChooseProductsControl1_ProductSelected(ByVal selectedProducts As System.Collections.Generic.List(Of NetShopForge.Library.Product.ProductSelectedInfo)) Handles ChooseProductsControl1.ProductSelected
        For Each ps As ProductSelectedInfo In selectedProducts
            Dim pl As New ProductLiksInfo
            pl.LinkType = 0
            pl.ProductAID = hfProductID.Value
            pl.ProductBID = ps.ProductID
            ProductController.AddProductLinks(pl)
        Next
        BindData()
    End Sub
End Class
