﻿
Partial Class Admin_Product_Controls_ProductNavControl
    Inherits System.Web.UI.UserControl

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load

        If Not IsPostBack Then
            Dim sProductID As String = Request("productid")
            If IsNothing(sProductID) OrElse Not IsNumeric(sProductID) Then
                ProductID.Text = "新商品"
                hlAddNewProduct.Visible = False
                MenuP.Enabled = False
            Else
                ProductID.Text = String.Format("#{0}", sProductID)

            End If
            BindBulletedList(sProductID)
            hlProductList.NavigateUrl = "~/Admin/Product/Product.aspx"
            hlAddNewProduct.NavigateUrl = "~/Admin/Product/Product.aspx?mode=addnew"
        End If

    End Sub

    Private Sub BindBulletedList(ByVal productID As String)
        Dim URL As String = "~/Admin/Product/Product.aspx?mode={0}&productid=" & productID

        MenuP.Items.Add(New MenuItem("基本信息", "", "", String.Format(URL, "details")))
        MenuP.Items.Add(New MenuItem("商品选项", "", "", String.Format(URL, "attribute")))
        MenuP.Items.Add(New MenuItem("描述部分", "", "", String.Format(URL, "descriptor")))
        MenuP.Items.Add(New MenuItem("扩展类别", "", "", String.Format(URL, "category")))
        MenuP.Items.Add(New MenuItem("商品图片", "", "", String.Format(URL, "images")))
        'MenuP.Items.Add(New MenuItem("会员价格", "", "", String.Format(URL, "price")))
        MenuP.Items.Add(New MenuItem("相关商品", "", "", String.Format(URL, "upselling")))
        'MenuP.Items.Add(New MenuItem("商品评论", "", "", String.Format(URL, "reviews")))
        ' MenuP.Items.Add(New MenuItem("商品品牌", "", "", String.Format(URL, "brand")))
        ' MenuP.Items.Item(5).Enabled = False
    End Sub
End Class
