﻿<%@ Control Language="VB" AutoEventWireup="false" CodeFile="ProductReviewControl.ascx.vb"
    Inherits="Admin_Product_Controls_ProductReviewControl" %>
<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>
<%@ Register Src="../../Controls/CheckAllCheckBoxControl.ascx" TagName="CheckAllCheckBoxControl"
    TagPrefix="uc1" %>
    <%@ Register Src="../../Controls/ResultMessageControl.ascx" TagName="ResultMessageControl"
    TagPrefix="uc2" %>
    <uc2:ResultMessageControl ID="ResultMessageControl1" runat="server" />
<div class="blankbox">
</div>
<div class="dialog-title">
    <asp:Label ID="lblDialogTitle" runat="server" Text="商品评论"></asp:Label>
</div>
<div class="dialog-box">
    <div class="row">
        <asp:DropDownList ID="ddlCategory" runat="server">
        </asp:DropDownList>
        <asp:DropDownList ID="ddlIsApproved" runat="server">
            <asp:ListItem Value="-1">审核情况</asp:ListItem>
            <asp:ListItem Value="1">已审核</asp:ListItem>
            <asp:ListItem Value="0">未审核 </asp:ListItem>
        </asp:DropDownList>
        <asp:TextBox ID="txtSearch" runat="server" onclick="if(this.value=='输入商品名称')this.value=''"
            onfocus="this.select()" onmouseover="this.focus()" value="输入商品名称"></asp:TextBox>
        <asp:Button ID="btnSearch" runat="server" Text="查找" Width="76px" />
    </div>
    <div class="grid">
        <asp:GridView ID="gvProductReview" runat="server" AllowPaging="True" AutoGenerateColumns="False"
            DataKeyNames="ReviewID" Width="100%" EmptyDataText="没有找到商品评论">
            <Columns>
                <asp:TemplateField>
                    <ItemTemplate>
                        <asp:CheckBox ID="cbSelect" runat="server" />
                    </ItemTemplate>
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle Width="25px" HorizontalAlign="Center" />
                    <HeaderTemplate>
                        <uc1:CheckAllCheckBoxControl ID="CheckAllCheckBoxControl1" runat="server" Prefix="cbSelect" />
                    </HeaderTemplate>
                </asp:TemplateField>
                <asp:BoundField DataField="ProductName" HeaderText="商品名称" />
                <asp:BoundField DataField="reviewerName" HeaderText="评论者" />
                <asp:BoundField DataField="ReviewDate" HeaderText="评论时间" DataFormatString="{0:f}"
                    HtmlEncode="False" />
                <asp:TemplateField HeaderText="评论">
                    <ItemTemplate>
                        <asp:HyperLink ID="hlComments" runat="server" ToolTip='<%# Eval("Comments") %>' NavigateUrl='<%# String.Format("~/Admin/Product/ProductReview.aspx?mode=feedback&reviewID={0}",eval("ReviewID")) %>'>评论</asp:HyperLink>

                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="审核" SortExpression="IsValid">
                    <ItemTemplate>
                        <asp:DropDownList ID="ddlIsApproved" runat="server" SelectedValue='<%# Cint(DataBinder.Eval(Container.DataItem,"IsApproved"))%>'>
                            <asp:ListItem Value="-1">是</asp:ListItem>
                            <asp:ListItem Value="0">否</asp:ListItem>
                        </asp:DropDownList>
                    </ItemTemplate>
                    <ItemStyle Width="50px" HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                </asp:TemplateField>
            </Columns>
            <PagerSettings Visible="False" />
        </asp:GridView>
    </div>
    <div class="grid-pager">
        <webdiyer:AspNetPager ID="Pager" runat="server" EnableTheming="False" FirstPageText='<span   style="font-family:Webdings, Wingdings" >9</span>'
            HorizontalAlign="Left" LastPageText='<span   style="font-family:Webdings, Wingdings" >:</span>'
            NextPageText='<span   style="font-family:Webdings, Wingdings" >4</span>' NumericButtonCount="8"
            NumericButtonTextFormatString="[{0}]" OnPageChanged="ChangePage" PageSize="10"
            PagingButtonSpacing="8px" PrevPageText='<span   style="font-family:Webdings, Wingdings" >3</span>'
            ShowCustomInfoSection="Right" SubmitButtonText="转到" Width="100%">
        </webdiyer:AspNetPager>
    </div>
    <div class="blankbox">
    </div>
    <div class="row">
        <asp:Button ID="btnDelete" runat="server" OnClientClick="Javascript:return toDel('gvProductReview');"
            Text="删除选择" Width="125px" />
        <asp:Button ID="btnApprove" runat="server" Text="更新审核" Width="125px" />
    </div>
</div>
<asp:HiddenField ID="hfSearchText" runat="server" />
