Imports NetShopForge.Library.Product
Imports NetShopForge.Library.Category
Partial Class Admin_Product_Controls_ProductReviewControl
    Inherits System.Web.UI.UserControl

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not IsPostBack Then
            hfSearchText.Value = ""
            CategoryTree.Instance.SetCategoryList(ddlCategory, "ȫ")
            BindData()
        End If
    End Sub

    Private Sub BindData()

        Dim totalRecords As Integer = 0
        Dim SearchText As String = hfSearchText.Value

        Dim prList As Generic.List(Of ProductReviewInfo) = Nothing
        Dim sqlWhere As String = ""
        If SearchText.Trim().Length <> 0 Then
            SearchText = SearchText.Replace("*", "%")
            SearchText = SearchText.Replace("?", "_")
            sqlWhere = String.Format("LOWER({1}) LIKE '{0}'", SearchText.ToLower.Replace("'", "''"), "ProductName")
        End If
        If sqlWhere.Length > 0 Then sqlWhere += " AND"

        Select Case ddlIsApproved.SelectedIndex
            Case 1
                sqlWhere += " IsApproved=1 "
            Case 2
                sqlWhere += " IsApproved=0 "
        End Select



        If ddlCategory.SelectedValue = -1 Then
            prList = ProductReviewController.GetProductReviewList(Pager.PageSize, Pager.CurrentPageIndex, totalRecords, sqlWhere)
        Else
            Dim pIDstring As String = ProductController.GetProductIDStringByCategoryID(CInt(ddlCategory.SelectedValue))
            If pIDstring.Length > 0 Then
                Dim sqlWhereString As String = String.Format("productID IN({0})", pIDstring)
                prList = ProductReviewController.GetProductReviewList(Pager.PageSize, Pager.CurrentPageIndex, totalRecords, sqlWhereString)
            End If
        End If

        Pager.RecordCount = totalRecords
        gvProductReview.DataSource = prList
        gvProductReview.DataBind()
        Pager.CustomInfoHTML = "¼:" + Pager.RecordCount.ToString()
        Pager.CustomInfoHTML += " ҳ:" + Pager.PageCount.ToString()
        Pager.CustomInfoHTML += " ǰҳ:" + Pager.CurrentPageIndex.ToString()
    End Sub

    Protected Sub ChangePage(ByVal src As Object, ByVal e As EventArgs) Handles Pager.PageChanged
        ' Dim startTime As System.DateTime = System.DateTime.Now

        BindData()
        'Dim endTime As System.DateTime = System.DateTime.Now
        'Dim ts As System.TimeSpan = endTime - startTime
        ''   Label1.Text = "ҳִʱ:" & ts.Milliseconds & " "
    End Sub

    Protected Sub btnSearch_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnSearch.Click
        hfSearchText.Value = txtSearch.Text
        If hfSearchText.Value = "Ʒ" Then hfSearchText.Value = ""
        Pager.CurrentPageIndex = 1
        BindData()
        txtSearch.Text = ""

    End Sub

   

    Protected Sub btnDelete_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnDelete.Click
        Try
            For i As Integer = 0 To gvProductReview.Rows.Count - 1
                If gvProductReview.Rows(i).RowType = DataControlRowType.DataRow Then
                    Dim cbSelect As CheckBox = CType(gvProductReview.Rows(i).FindControl("cbSelect"), CheckBox)
                    Dim reviewID As Integer = CInt(gvProductReview.DataKeys(i).Value)
                    ProductReviewController.DeleteProductReview(reviewID)
                End If
            Next i
            BindData()
            ResultMessageControl1.ShowSuccess("ɾɹ")
        Catch ex As Exception
            ResultMessageControl1.ShowSuccess("ɾʧܣ" & ex.Message)
        End Try
      

    End Sub


    Protected Sub btnApprove_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnApprove.Click
        Try
            For i As Integer = 0 To gvProductReview.Rows.Count - 1
                If gvProductReview.Rows(i).RowType = DataControlRowType.DataRow Then
                    Dim ddlIsApproved As DropDownList = CType(gvProductReview.Rows(i).FindControl("ddlIsApproved"), DropDownList)
                    Dim reviewID As Integer = CInt(gvProductReview.DataKeys(i).Value)
                    ProductReviewController.UpdateProductReview(reviewID, CBool(ddlIsApproved.SelectedValue))
                End If
            Next i
            BindData()
            ResultMessageControl1.ShowSuccess("³ɹ")
        Catch ex As Exception
            ResultMessageControl1.ShowSuccess("ʧܣ" & ex.Message)
        End Try
    End Sub
End Class
