
Partial Class Shop_Cart_Checkout
    Inherits System.Web.UI.Page

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load

        Dim mode As String = Request("mode")
        LoadCartControl(mode)

    End Sub

    Private Sub LoadCartControl(ByVal mode As String)

        If Not My.User.IsAuthenticated Then
            mode = "account"
        Else
            If IsNothing(mode) Then mode = "orderreview"
        End If

        Dim uc As UserControl = Nothing
        Select Case mode.ToLower
            Case "account"
                uc = CType(LoadControl("Shop/Checkout/AccountControl.ascx"), UserControl)
            Case "ordercomplete"
                uc = CType(LoadControl("shop/Checkout/OrderCompleteControl.ascx"), UserControl)
            Case "orderreview"
                uc = CType(LoadControl("shop/Checkout/OrderReviewControl.ascx"), UserControl)
            Case "shippingaddress"
                uc = CType(LoadControl("Shop/Checkout/ShippingAddressControl.ascx"), UserControl)
            Case "paymentmethod"
                uc = CType(LoadControl("Shop/Checkout/PaymentMethodControl.ascx"), UserControl)
            Case "shippingmethod"
                uc = CType(LoadControl("Shop/Checkout/ShippingMethodControl.ascx"), UserControl)
            Case Else
                uc = CType(LoadControl("Shop/Checkout/ShippingAddressControl.ascx"), UserControl)
        End Select
        phCheckout.Controls.Clear()
        phCheckout.Controls.Add(uc)

    End Sub


    'Private Function GetMode() As String

    '    If IsNothing(Profile.LastShippingAddress.RegionID) OrElse Not IsNumeric(Profile.LastShippingAddress.RegionID) Then
    '        Return "shippingadress"
    '    End If

    '    If IsNothing(Profile.LastShippingMethod) OrElse Profile.LastShippingMethod.Length = 0 Then
    '        Return "shippingmethod"
    '    End If

    '    If IsNothing(Profile.LastPaymentMethod) OrElse Profile.LastPaymentMethod.Length = 0 Then
    '        Return "paymentmethod"
    '    End If
    '    Return Nothing
    'End Function

    'Private Sub GoPage(ByVal mode As String)
    '    Dim url As String = String.Format("~/Checkout.aspx?mode={0}", mode)
    '    My.Response.Redirect(url)
    'End Sub
End Class
