<%@ WebHandler Language="VB" Class="ImageHandler" %>
Imports System.Drawing
Imports System.IO
Imports NetShopForge.Common.nsfImage
Imports System
Imports System.Web

Public Class ImageHandler : Implements IHttpHandler
    Public Const NOIMAGE_PATH As String = "~/Image_Shop/Products/noimage.gif"
    Public Sub ProcessRequest(ByVal context As HttpContext) Implements IHttpHandler.ProcessRequest
        'Put user code to initialize the page here
        Dim ImagePath As String = System.Web.HttpUtility.UrlDecode(context.Request("Imagepath"))

        If Not File.Exists(context.Server.MapPath(ImagePath)) Then ImagePath = NOIMAGE_PATH
        Dim IsWaterMark As Boolean = False


        Using i As System.Drawing.Image = System.Drawing.Image.FromFile(context.Server.MapPath(ImagePath))
            If IsWaterMark Then
                Dim objWM As New WaterMarkController(i, "NetShopForge", "", False, Color.Red, 0, 0)
                Using iMarkedImage As System.Drawing.Image = objWM.MarkedImage
                    Using j As System.Drawing.Image = GenerateThumbnail(iMarkedImage, context.Request("Size"))
                        context.Response.ContentType = "image/jpeg"
                        j.Save(context.Response.OutputStream, System.Drawing.Imaging.ImageFormat.Jpeg)
                    End Using
                End Using
            Else
                Using j As System.Drawing.Image = GenerateThumbnail(i, context.Request("Size"))
                    context.Response.ContentType = "image/jpeg"
                    j.Save(context.Response.OutputStream, System.Drawing.Imaging.ImageFormat.Jpeg)
                End Using
            End If
        End Using

        
    End Sub
 
    Public ReadOnly Property IsReusable() As Boolean Implements IHttpHandler.IsReusable
        Get
            Return False
        End Get
    End Property
    Private Function GenerateThumbnail(ByVal original As Image, ByVal size As String) As Image

        Dim w, h, sizeW, sizeH As Integer
        w = original.Width
        h = original.Height
        Dim sizes() As String = size.Split(",")
        sizeW = sizes(0)
        sizeH = sizes(1)

        If CInt(sizeH) = -1 Then Return original

        If w > h Then
            w = sizeW
            h = CInt(w * (CType(original.Height, Double) / CType(original.Width, Double)))
        Else
            h = sizeH
            w = CInt(h * (CType(original.Width, Double) / CType(original.Height, Double)))
        End If

        'Using tn As New Bitmap(w, h)
        '    Using g As Graphics = Graphics.FromImage(tn)
        '        g.InterpolationMode = System.Drawing.Drawing2D.InterpolationMode.HighQualityBilinear 'experiment with this...
        '        g.DrawImage(original, New Rectangle(0, 0, tn.Width, tn.Height), 0, 0, original.Width, original.Height, GraphicsUnit.Pixel)
        '    End Using
        '    Return CType(tn, Image)
        'End Using

        Dim tn As New Bitmap(w, h)

        Dim g As Graphics = Graphics.FromImage(tn)

        g.InterpolationMode = System.Drawing.Drawing2D.InterpolationMode.HighQualityBilinear 'experiment with this...

        g.DrawImage(original, New Rectangle(0, 0, tn.Width, tn.Height), 0, 0, original.Width, original.Height, GraphicsUnit.Pixel)

        g.Dispose()

        Return CType(tn, Image)

    End Function 'GenerateThumbnail
End Class