
Imports NetShopForge.Library.Product
Imports NetShopForge.Common
Imports NetShopForge.Library.Tracker
Imports System.IO
Imports System.IO.Compression
Imports System
Imports System.Net

Partial Class Shop_Product_ProductDetail
    Inherits System.Web.UI.Page

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load

        '###############################################################################
        '  Page Validators - these must be implemented or they will be redirected
        '###############################################################################

        Dim pID As Integer = Utility.GetIntParameter("pID")
        If pID <> 0 Then

            Dim p As ProductInfo = ProductController.GetProduct(pID)
            BindData(p)
            TickStats(p)
            Page.Title = p.ProductName
        Else
            Response.Redirect(Page.ResolveUrl("~/404.aspx"))
        End If


    End Sub

    Private Sub BindData(ByVal p As ProductInfo)

        Dim pv As New Generic.List(Of ProductReviewInfo)

        ProductDetailControl1.objProduct = p
        ProductDetailControl1.NormalImagePath = p.NormalImagePath
        If p.Description.Trim.Length > 0 Then
            ProductDescriptionControl1.ProductDescription = p.Description
        Else
            ProductDescriptionControl1.Visible = False
        End If
        ProductDescriptorsDisplayControl1.DescriptorList = ProductController.GetDescriptorList(p.ProductID)
        CustomerReviewControl1.ProductID = p.ProductID
        CustomerReviewControl1.ProductReviewList = ProductReviewController.GetProductReviewList(10, 1, -2, String.Format("ProductID={0}", p.ProductID))
        ' CategoryMapPathControl1.ProductID = p.ProductID
        ProductRelationControl1.ProductID = p.ProductID
        linkProductURL.NavigateUrl = p.ProductURL
        linkProductURL.Text = p.ProductURL

        setProductURL(p.ProductURL)


    End Sub

    'Private Sub BindNavigation()
    '    Dim list As Generic.Dictionary(Of String, String) = New Generic.Dictionary(Of String, String)
    '    list.Add("Description", Request.RawUrl & "#aDescription")
    '    If ProductFeatureControl1.Visible Then list.Add("Feature", Request.RawUrl & "#aFeature")
    '    list.Add("Review", Request.RawUrl & "#aReview")
    '    If ProductFeatureControl1.Visible Then list.Add("Relation", Request.RawUrl & "#aRelation")
    '    list.Add("Tell a Friend", Request.RawUrl & "#SendEmail")
    'End Sub

    Private Sub TickStats(ByVal Product As ProductInfo)
        'track this
        If Not IsPostBack Then
            Profile.RecentlyViewedProducts.AddProduct(Product.ProductID, Product.ProductName, Product.ImagePath)
            TrackerController.Add(BehaviorType.BrowsingProduct, Product.ProductID)
            '  ProfileManager.DeleteInactiveProfiles(ProfileAuthenticationOption.Anonymous, Today.AddDays(365))


        End If
     
    End Sub

    Private Sub setProductURL(ByVal url As String)
        Dim encodingName As String = GetEncoding(url)

        'Dim contentType As String = headers("Content-Type")
        'If contentType.IndexOf("charset") > 0 AndAlso (reg_charset.IsMatch(contentType)) Then
        '    encodingName = reg_charset.Match(contentType).Groups("charset").Value
        'End If

        ProductURL.Text = GetHtml(url, Encoding.GetEncoding(encodingName))


    End Sub

    Private Function GetEncoding(ByVal url As String) As String
        Dim request As HttpWebRequest = Nothing
        Dim response As HttpWebResponse = Nothing
        Dim reader As StreamReader = Nothing
        Try
            request = DirectCast(WebRequest.Create(url), HttpWebRequest)
            request.Timeout = 20000
            request.AllowAutoRedirect = False
            response = DirectCast(request.GetResponse(), HttpWebResponse)
            If response.StatusCode = HttpStatusCode.OK AndAlso response.ContentLength < 1024 * 1024 Then
                If response.ContentEncoding IsNot Nothing AndAlso response.ContentEncoding.Equals("gzip", StringComparison.InvariantCultureIgnoreCase) Then
                    reader = New StreamReader(New GZipStream(response.GetResponseStream(), CompressionMode.Decompress))
                Else
                    reader = New StreamReader(response.GetResponseStream(), Encoding.ASCII)
                End If
                Dim html As String = reader.ReadToEnd()
                Dim reg_charset As New Regex("charset\b\s*=\s*(?<charset>[^""]*)")
                If reg_charset.IsMatch(html) Then
                    Return reg_charset.Match(html).Groups("charset").Value
                ElseIf response.CharacterSet <> String.Empty Then
                    Return response.CharacterSet
                Else
                    Return Encoding.[Default].BodyName
                End If
            End If
        Catch
        Finally
            If response IsNot Nothing Then
                response.Close()
                response = Nothing
            End If
            If reader IsNot Nothing Then
                reader.Close()
            End If
            If request IsNot Nothing Then
                request = Nothing
            End If
        End Try
        Return Encoding.[Default].BodyName
    End Function
    ''' <summary> 
    ''' ȡԴ 
    ''' </summary> 
    ''' <param name="url"></param> 
    ''' <returns></returns> 
    Private Shared Function GetHtml(ByVal url As String, ByVal encoding As Encoding) As String
        Dim request As HttpWebRequest = Nothing
        Dim response As HttpWebResponse = Nothing
        Dim reader As StreamReader = Nothing
        Try
            request = DirectCast(WebRequest.Create(url), HttpWebRequest)
            request.Timeout = 20000
            request.AllowAutoRedirect = False
            response = DirectCast(request.GetResponse(), HttpWebResponse)
            If response.StatusCode = HttpStatusCode.OK AndAlso response.ContentLength < 1024 * 1024 Then
                If response.ContentEncoding IsNot Nothing AndAlso response.ContentEncoding.Equals("gzip", StringComparison.InvariantCultureIgnoreCase) Then
                    reader = New StreamReader(New GZipStream(response.GetResponseStream(), CompressionMode.Decompress), encoding)
                Else
                    reader = New StreamReader(response.GetResponseStream(), encoding)
                End If
                Dim html As String = reader.ReadToEnd()
                Return html
            End If
        Catch
        Finally
            If response IsNot Nothing Then
                response.Close()
                response = Nothing
            End If
            If reader IsNot Nothing Then
                reader.Close()
            End If
            If request IsNot Nothing Then
                request = Nothing
            End If
        End Try
        Return String.Empty
    End Function

End Class
