Imports NetShopForge.Library.Cart
Imports System.Collections.Generic

Partial Class Shop_Cart_Control_CartControl
    Inherits System.Web.UI.UserControl

    Private Sub BindCart()

        Dim cartCollection As ICollection(Of CartInfo) = Profile.ShoppingCart.CartCollection
        If cartCollection.Count > 0 Then
            gvCart.DataSource = cartCollection
            gvCart.DataBind()
            CalculateTotal()
            pCart.Visible = True
        Else
            gvCart.DataSource = Nothing
            gvCart.DataBind()
            pCart.Visible = False
            BindBulletedCategroyList()
        End If

    End Sub




    Private Sub CalculateTotal()
        If Profile.ShoppingCart.CartCollection.Count > 0 Then
            lblTotal.Text = Profile.ShoppingCart.Total.ToString("c")
        End If
    End Sub

    Private Sub BindBulletedCategroyList()

    End Sub

 

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load

        If Not Page.IsPostBack Then
            BindCart()
        End If

    End Sub


    Protected Sub btnDelete_Click(ByVal sender As Object, ByVal e As System.Web.UI.ImageClickEventArgs)
        Dim itemID As String = CType(sender, ImageButton).CommandArgument
        Profile.ShoppingCart.Remove(itemID)
        BindCart()
    End Sub

    Protected Sub btnAddToWishList_Click(ByVal sender As Object, ByVal e As System.Web.UI.ImageClickEventArgs)
        Dim ProductID As String = CType(sender, ImageButton).CommandArgument
        My.Response.Redirect(String.Format("~/User.aspx?mode=wishlist&pID={0}", ProductID))
    End Sub

    Protected Sub btnClear_Click(ByVal sender As Object, ByVal e As System.Web.UI.ImageClickEventArgs)
        For I As Integer = 0 To gvCart.Rows.Count - 1

            Dim itemID As String = String.Format("{0}|{1}", gvCart.DataKeys(I).Item("ProductID"), gvCart.DataKeys(I).Item("Options"))
            Profile.ShoppingCart.Remove(itemID)
        Next
BindCart
    End Sub


    Protected Sub btnRecalculate_Click(ByVal sender As Object, ByVal e As System.Web.UI.ImageClickEventArgs) Handles btnRecalculate.Click

        Dim total As Decimal = 0
        Dim qty As Integer
        Dim r As GridViewRow
        For Each r In gvCart.Rows
            If r.RowType = DataControlRowType.DataRow Then
                Dim t As TextBox = CType(r.Cells(3).Controls(1), TextBox)
                If Integer.TryParse(t.Text, qty) Then
                    Dim ItemID As String = String.Format("{0}|{1}", gvCart.DataKeys(r.RowIndex)("ProductID").ToString, gvCart.DataKeys(r.RowIndex)("Options").ToString)
                    If qty > 0 Then
                        Profile.ShoppingCart.SetQuantity(ItemID, qty)
                    ElseIf qty = 0 Then
                        Profile.ShoppingCart.Remove(ItemID)
                    End If
                End If
            End If
        Next
        BindCart()
    End Sub
End Class
