Imports NetShopForge.Library.Cart
Imports System.Collections.Generic
Partial Class Shop_Cart_Controls_MiniCartControl
    Inherits System.Web.UI.UserControl

    Private Sub BindCart()

        Dim cartCollection As ICollection(Of CartInfo) = Profile.ShoppingCart.CartCollection
        If cartCollection.Count > 0 Then
            rptBasket.DataSource = cartCollection
            rptBasket.DataBind()
            Calculate()
        Else
            rptBasket.Visible = False
            lblSubtotal.Visible = False
            lblMsg.Text = "Ĺ복ǿյ"
        End If
      
    End Sub

    Private Sub SetSpecialOfferButtone(ByVal enabled As Boolean)
        hlSpecailOffer.Enabled = enabled
        hlSpecailOffer.NavigateUrl = "#"
        If enabled Then
            hlSpecailOffer.ImageUrl = "~/Images/Shop/gospecialoffer_true.gif"
        Else
            hlSpecailOffer.ImageUrl = "~/Images/Shop/gospecialoffer_false.gif"
        End If

    End Sub

    Private Sub Calculate()

        If Profile.ShoppingCart.CartCollection.Count > 0 Then
            lblSubtotal.Text = Profile.ShoppingCart.Total.ToString
        End If
    End Sub


    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load

        If Not Page.IsPostBack Then
            BindCart()
            SetSpecialOfferButtone(False)
        End If

    End Sub
End Class
