Imports System.Data
Imports NetShopForge.Library.Category
Partial Class Shop_Category_Controls_CategoryTreeControl
    Inherits System.Web.UI.UserControl
    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not IsPostBack Then
            If Not Page.IsPostBack Then
                PopulateNodes(TreeView1.Nodes, -1)
            End If
        End If

    End Sub


    Public Function GetTreeTable() As DataTable
        Using dt As DataTable = HttpContext.Current.Cache("CategoryTable")
            If IsNothing(dt) Then
                Using t As DataTable = CategoryController.GetCategoryList(-2).Tables(0)
                    HttpContext.Current.Cache.Insert("CategoryTable", t)
                    Return t
                End Using
            End If
            Return dt
        End Using


    End Function


    Public Sub PopulateNodes(ByVal nodes As TreeNodeCollection, Optional ByVal categoryFatherID As Int32 = -1)

        Dim dt As New DataTable()
        dt = GetTreeTable()
        Dim strExpression As String
        strExpression = String.Format("CategoryFatherID={0}", categoryFatherID)
        Dim foundRows() As DataRow
        foundRows = dt.Select(strExpression)

        Dim I As Integer
        For I = 0 To foundRows.GetUpperBound(0)
            Dim tn As New TreeNode()
            tn.Text = foundRows(I).Item("CategoryName").ToString()
            tn.Value = foundRows(I).Item("CategoryID").ToString()
            If categoryFatherID = -1 Then
                tn.NavigateUrl = String.Format("~/Category.aspx?CatID={0}", tn.Value)
            Else
                tn.NavigateUrl = String.Format("~/Category.aspx?CatID={0}", tn.Value)
            End If
            Dim dr() As DataRow
            dr = dt.Select("[CategoryFatherID] = " & tn.Value)
            If dr.GetUpperBound(0) > -1 Then
                tn.PopulateOnDemand = True
            End If
            nodes.Add(tn)
        Next
    End Sub

    Protected Sub TreeView1_TreeNodePopulate(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.TreeNodeEventArgs) Handles TreeView1.TreeNodePopulate
        PopulateNodes(e.Node.ChildNodes, e.Node.Value)
    End Sub
End Class
