Imports NetShopForge.Library.Cart
Imports NetShopForge.Library.Address
Imports System.Collections.Generic
Imports NetShopForge.Library.Shipping
Imports NetShopForge.Library.Payment
Imports NetShopForge.Common
Imports NetShopForge.Library.Order

Partial Class Shop_Checkout_OrderReviewControl
    Inherits System.Web.UI.UserControl


#Region "---EventArg Method---"
    'Protected Sub btnUseCoupon_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnUseCoupon.Click
    '    Dim random As Random = New Random()
    '    SetFeeInfo(20)
    'End Sub

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load

        If Not IsPostBack Then
            If IsNothing(Profile.LastShippingAddress.RegionID) OrElse Not IsNumeric(Profile.LastShippingAddress.RegionID) Then
                GoPage("shippingadress")
            End If

            If IsNothing(Profile.LastShippingMethod) OrElse Profile.LastShippingMethod.Length = 0 Then
                GoPage("shippingmethod")
            End If

            If IsNothing(Profile.LastPaymentMethod) OrElse Profile.LastPaymentMethod.Length = 0 Then
                GoPage("paymentmethod")
            End If
            Binddata()
            SetFeeInfo(0)
        End If
    End Sub

    Protected Sub btnEditPaymentMethod_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnEditPaymentMethod.Click
        GoPage("paymentmethod")
    End Sub

    Protected Sub btnEditShippingAddress_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnEditShippingAddress.Click
        GoPage("shippingadress")
    End Sub

    'Protected Sub btnEditShippingMethod_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnEditShippingMethod.Click
    '    GoPage("shippingmethod")
    'End Sub

    Protected Sub btnCreatOrder_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnCreatOrder.Click
        btnCreatOrder.Enabled = False
        Dim orderID As String = CreateOrder()

        'Clear User's shopping cart in profile
        Profile.ShoppingCart.Clear()

        Dim url As String = String.Format("~/Checkout.aspx?mode=ordercomplete&orderid={0}", orderID)
        My.Response.Redirect(url)
    End Sub

#End Region

#Region "--Private---"

    Private Sub Binddata()
        Dim objS As ShippingMethodInfo
        Dim objP As PaymentMethodInfo
        Dim objpc As New PaymentController
        objP = objpc.GetPaymentMethodInfo(CInt(Profile.LastPaymentMethod))
        Dim objSC As New ShippingController
        objS = objSC.GetShippingMethod(CInt(Profile.LastShippingMethod))

        hfSFee.Value = objS.ShippingPrice
        ShippingAddress.Text = Profile.LastShippingAddress.FullAddress
        '  ShippingMethod.Text = GetShippingMethodString(objS)
        PaymentMethod.Text = GetPaymentMethodString(objP)
        BindShippingItem()

    End Sub

    Private Function GetShippingMethodString(ByVal objS As ShippingMethodInfo) As String

        Dim sbOut As New System.Text.StringBuilder
        sbOut.Append("<table>")
        sbOut.Append(String.Format("<tr><td><b>{0}</b></td></tr><tr><td>ͷ:{1} </td></tr>", objS.ShippingMethodName, String.Format("{0:c}", objS.ShippingPrice)))
        sbOut.Append("<tr><td>" & objS.ShippingMethodDescription & "</td></tr>")
        sbOut.Append("</table>")
        Return sbOut.ToString

    End Function

    Private Function GetPaymentMethodString(ByVal objp As PaymentMethodInfo) As String


        Dim sbOut As New System.Text.StringBuilder
        sbOut.Append("<table>")
        sbOut.Append(String.Format("<tr><td><b>{0}</b></td></tr>", objP.PaymentMethodName))
        sbOut.Append("<tr><td>" & objP.Description & "</td></tr>")
        sbOut.Append("</table>")
        Return sbOut.ToString
    End Function

    Private Sub BindShippingItem()
        'bind Product 
        Dim cartCollection As ICollection(Of CartInfo) = Profile.ShoppingCart.CartCollection
        If cartCollection.Count > 0 Then
            gvCart.DataSource = cartCollection
            gvCart.DataBind()
        Else
            gvCart.DataSource = Nothing
            gvCart.DataBind()
        End If
    End Sub

    Private Sub SetFeeInfo(ByVal cFee As Decimal)

        Dim tFee, sFee As Decimal
        tFee = Profile.ShoppingCart.Total
        sFee = hfSFee.Value
        hfOFee.Value = tFee + sFee - cFee

        Dim sbOut As New System.Text.StringBuilder
        sbOut.Append("<table border=""0"" cellpadding=""0"" cellspacing=""0"" style=""width: 100%"">")
        sbOut.Append(String.Format("<tr><td style=""width: 120px"">{0}</td><td>{1}</td></tr>", "۸ܼƣ", String.Format("{0:c}", tFee)))
        sbOut.Append(String.Format("<tr><td style=""width: 120px"">{0}</td><td>{1}</td></tr>", "˷ѣ", String.Format("{0:c}", sFee)))
        If cFee > 0 Then sbOut.Append(String.Format("<tr><td style=""width: 120px"">{0}</td><td  style=""color: red;"">{1}</td></tr>", "ۿۣ", String.Format("{0:c}", -cFee)))
        sbOut.Append("<tr><td align=""left"" class=""ReviewLinks"" colspan=""2"">")
        sbOut.Append(" <hr />")
        sbOut.Append(String.Format("{0}{1}</td> </tr>", "ܼƣ", String.Format("{0:c}", tFee + sFee - cFee)))
        sbOut.Append("</table>")
        Fee.text = sbOut.ToString

    End Sub

    Private Function CreateOrder() As String
      
        ' Dim oc As New OrderController
        Dim OrderID As String
        OrderID = OrderController.CreateOrder(GetProvisionOrder, GetProvisionOrderItems)
        Return OrderID

    End Function

    Private Function GetProvisionOrderItems() As List(Of OrderDetailInfo)
        Dim oItems As New List(Of OrderDetailInfo)
        Dim C As CartInfo

        For Each C In Profile.ShoppingCart.CartCollection
            Dim Item As New OrderDetailInfo
            Item.ProductID = C.ProductID
            Item.UnitCost = C.UnitPrice
            Item.Quantity = C.Quantity
            Item.ProductOptions = C.Options
            Item.Discount = 0

            oItems.Add(Item)
        Next

        Return oItems
    End Function

    Private Function GetProvisionOrder() As OrderInfo
        Dim O As New OrderInfo
        O.BillingAddress = Profile.Address
        O.BillingArea = Profile.Area
        O.BillingCounTry = "CN"
        O.BillingCity = Profile.City
        O.BillingName = Profile.Name
        O.BillingPhone = Profile.Phone
        O.BillingPostalCode = Profile.ZipCode
        O.BillingState = Profile.State
        If hfCFee.Value.ToString.Length > 0 Then
            O.CouponFee = Decimal.Parse(hfCFee.Value)
        Else
            O.CouponFee = 0.0
        End If
        O.CustomerNote = ""
        O.DiscountFee = 0
        O.InvoiceTitle = ""
        O.IsCancel = False
        O.NeedInvoice = False
        O.OrderDate = Now
        O.OrderStatus = OrderStatus.NotProcessed
        O.PaymentMethodID = Profile.LastPaymentMethod
        O.ProductSubtotalFee = Profile.ShoppingCart.Total
        O.SendDate = Now
        O.ShipAreaID = Profile.LastShippingAddress.AreaID
        O.ShipAddress = Profile.LastShippingAddress.Address1
        O.ShipAddress2 = Profile.LastShippingAddress.Address2
        O.ShipArea = Profile.LastShippingAddress.Area
        O.ShipCity = Profile.LastShippingAddress.City
        O.ShipCountry = Profile.LastShippingAddress.Country
        O.ShipName = Profile.LastShippingAddress.FirstName & " " & Profile.LastShippingAddress.LastName
        O.ShippingFee = hfSFee.Value
        O.ShippingMethodID = Profile.LastShippingMethod
        O.ShipPostalCode = Profile.LastShippingAddress.Zip
        O.ShipState = Profile.LastShippingAddress.Province

        O.ShipPhone = Profile.LastShippingAddress.Phone


        O.TotalFee = hfOFee.Value
        O.UserName = My.User.Name
        O.UserID = 2006

        Return O
    End Function

    Private Sub GoPage(ByVal mode As String)
        Dim url As String = String.Format("~/Checkout.aspx?mode={0}", mode)
        My.Response.Redirect(url)
    End Sub

#End Region


End Class
