
Imports NetShopForge.Library.Shipping

Partial Class Shop_Checkout_PayMethodControl
    Inherits System.Web.UI.UserControl

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        BindPaymentMethod()
    End Sub

    Private Sub BindPaymentMethod()

     
        If IsNothing(Profile.LastShippingAddress.RegionID) OrElse Not IsNumeric(Profile.LastShippingAddress.RegionID) Then
            GoPage("shippingadress")
        End If

        If IsNothing(Profile.LastShippingMethod) OrElse Profile.LastShippingMethod.Length = 0 Then
            GoPage("shippingadress")
        End If


        Dim ShippingMethodID As Integer = Integer.Parse(Profile.LastShippingMethod)
        Dim objSC As New ShippingController
        Dim objShipping As ShippingMethodInfo = objSC.GetShippingMethod(ShippingMethodID)
        Dim objPC As New Payment.PaymentController
        rpPayment.DataSource = objPC.GetPaymentMethodList(objShipping.PaymentMethodCollection)
        rpPayment.DataBind()
    End Sub


    Private Sub SetPaymentMethodInProfile()

        Dim i As Integer
        For i = 0 To rpPayment.Items.Count - 1
            Dim rbShippingMethod As RadioButton = CType(rpPayment.Items(i).FindControl("rbPayment"), RadioButton)
            If Not IsNothing(rbShippingMethod) AndAlso rbShippingMethod.Checked Then
                Dim hfPamentID As HiddenField = CType(rpPayment.Items(i).FindControl("hfPamentID"), HiddenField)
                Profile.LastPaymentMethod = hfPamentID.Value
            End If
        Next
    End Sub

    Protected Sub btnGoShippingMethod_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnGoShippingMethod.Click
        GoPage("shippingmethod")
    End Sub

    Protected Sub btnGoOrderReview_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnGoOrderReview.Click
        SetPaymentMethodInProfile()
        GoPage("orderreview")
    End Sub

    Private Sub GoPage(ByVal mode As String)
        Dim url As String = String.Format("~/Checkout.aspx?mode={0}", mode)
        My.Response.Redirect(url)
    End Sub

    Protected Sub rpPayment_ItemDataBound(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.RepeaterItemEventArgs) Handles rpPayment.ItemDataBound

        If e.Item.ItemType = ListItemType.Item Or e.Item.ItemType = ListItemType.AlternatingItem Then
            Dim hfPamentID As HiddenField = CType(e.Item.FindControl("hfPamentID"), HiddenField)
            If String.Equals(Profile.LastPaymentMethod, hfPamentID.Value) Then
                Dim rbShippingMethod As RadioButton = CType(e.Item.FindControl("rbPayment"), RadioButton)
                If Not IsNothing(rbShippingMethod) Then rbShippingMethod.Checked = True
            End If


        End If
    End Sub
End Class
