
Imports NetShopForge.Library.Cart
Imports NetShopForge.Library.Address
Imports System.Collections.Generic
Imports NetShopForge.Library.Shipping
Imports NetShopForge.Library.Payment
Imports NetShopForge.Common
Imports NetShopForge.Library.Order

Partial Class Shop_Cart_Controls_ShippingAddressControl
    Inherits System.Web.UI.UserControl

    Protected currentOrder As Order.OrderInfo = Nothing

#Region "---Public Property---"

    Public Property SelectedAddress() As AddressInfo
        Get

            'return the entered text bits as an address
            Dim address As New AddressInfo
            address.Address1 = txtSAddress.Text
            address.Country = "й"
            address.City = AreaControl1.City
            address.FirstName = txtSName.Text
            address.Phone = txtSPhone.Text
            address.Zip = txtSPostCode.Text
            address.Province = AreaControl1.Province
            address.Area = AreaControl1.Area
            address.AreaID = AreaControl1.AreaID
            address.RegionID = CInt(ddlShippingRegion.SelectedValue)
            Return address

        End Get
        Set(ByVal value As AddressInfo)
            txtSAddress.Text = value.Address1
            AreaControl1.AreaID = value.AreaID
            txtSName.Text = value.FirstName
            txtSPhone.Text = value.Phone
            txtSPostCode.Text = value.Zip
            Dim list As System.Web.UI.WebControls.ListItem = ddlShippingRegion.Items.FindByValue(value.RegionID)
            If Not IsNothing(list) Then ddlShippingRegion.SelectedValue = list.Value

        End Set
    End Property

#End Region

#Region "---Event Method---"

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        ValidatePage()
        If Not IsPostBack Then

            BindAddressList()

            BindShippingRegion()

            BindData()


        End If

    End Sub

    Protected Sub dtAddresses_ItemCommand(ByVal source As Object, ByVal e As System.Web.UI.WebControls.DataListCommandEventArgs) Handles dtAddresses.ItemCommand
        Dim lblID As Label = CType(e.Item.FindControl("lblAddressID"), Label)
        If Not lblID Is Nothing Then
            Dim shipAddressID As Integer = Integer.Parse(lblID.Text)
            Dim shipAddress As AddressInfo
            Dim objAC As New AddressController
            shipAddress = objAC.GetAddress(shipAddressID)
            Me.SelectedAddress = shipAddress

        End If
    End Sub

    Protected Sub btnGoShippingMethod_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnGoShippingMethod.Click
        Profile.LastShippingAddress = SelectedAddress
        Dim url As String = String.Format("~/Checkout.aspx?mode=paymentmethod")
        My.Response.Redirect(url)
    End Sub

#End Region

#Region "---Private Method---"
    Private Sub BindData()
        'bind default address

        Dim address As AddressInfo = Profile.LastShippingAddress
        If Not IsNothing(address) Then SelectedAddress = address

    End Sub

    ''' <summary>
    ''' Bind User's Address book
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub BindAddressList()
        Dim objAc As New Address.AddressController
        dtAddresses.DataSource = objAc.GetAddressList(My.User.Name)
        dtAddresses.DataBind()
        ' If dtAddresses.Items.Count = 0 Then dtAddresses.Caption = "ûеַб"
    End Sub

    Private Sub BindShippingRegion()
        Dim objSC As New ShippingController

        ddlShippingRegion.DataTextField = "Name"
        ddlShippingRegion.DataValueField = "ShippingRegionID"
        ddlShippingRegion.DataSource = objSC.GetShippingRegionList
        ddlShippingRegion.DataBind()
        ddlShippingRegion.Items.Insert(0, New ListItem("<ѡ>", ""))
    End Sub



    Private Sub ValidatePage()
        'Page Validation
        '1) Need items in order to checkout
        If Profile.ShoppingCart.Count = 0 Then
            Response.Redirect("~/Cart.aspx", True)
        End If

        '2) Need to have this page under SSL!
        Utility.TestForSSL()

    End Sub


#End Region

End Class
