
Imports NetShopForge.Library.Shipping

Partial Class Shop_Checkout_ShippingMethodControl
    Inherits System.Web.UI.UserControl


    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not IsPostBack Then
            BindShipingMethod()
        End If
    End Sub

    Private Sub BindShipingMethod()


        If IsNothing(Profile.LastShippingAddress.RegionID) OrElse Not IsNumeric(Profile.LastShippingAddress.RegionID) Then
            GoPage("shippingadress")
        End If
        Dim regionID As Integer = Integer.Parse(Profile.LastShippingAddress.RegionID)

        Dim objSC As New ShippingController
        rpShippingMethod.DataSource = objSC.GetShippingMethodList(regionID)
        rpShippingMethod.DataBind()
    End Sub


    Private Sub SetShippingMethedInProfile()

        Dim i As Integer
        For i = 0 To rpShippingMethod.Items.Count - 1
            Dim rbShippingMethod As RadioButton = CType(rpShippingMethod.Items(i).FindControl("rbShippingMethod"), RadioButton)
            If Not IsNothing(rbShippingMethod) AndAlso rbShippingMethod.Checked Then
                Dim hfShippingMethodID As HiddenField = CType(rpShippingMethod.Items(i).FindControl("hfShippingMethodID"), HiddenField)
                Profile.LastShippingMethod = hfShippingMethodID.Value
            End If
        Next
    End Sub

    Protected Sub rpShippingMethod_ItemDataBound(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.RepeaterItemEventArgs) Handles rpShippingMethod.ItemDataBound

        If e.Item.ItemType = ListItemType.Item Or e.Item.ItemType = ListItemType.AlternatingItem Then
            Dim hfShippingMethodID As HiddenField = CType(e.Item.FindControl("hfShippingMethodID"), HiddenField)
            '   Dim LiteralShippingFee As Literal = CType(e.Item.FindControl("LiteralShippingFee"), Literal)
            '    LiteralShippingFee.Text = Now.ToShortTimeString

            If String.Equals(hfShippingMethodID.Value, Profile.LastShippingMethod) Then
                Dim rbShippingMethod As RadioButton = CType(e.Item.FindControl("rbShippingMethod"), RadioButton)
                rbShippingMethod.Checked = True
            End If
           
        End If
    End Sub

    Protected Sub btnGoShippingAddress_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnGoShippingAddress.Click
        GoPage("shippingadress")
    End Sub



    Protected Sub btnGoPaymentMethod_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnGoPaymentMethod.Click
        SetShippingMethedInProfile()
        GoPage("paymentmethod")
    End Sub

    Private Sub GoPage(ByVal mode As String)
        Dim url As String = String.Format("~/Checkout.aspx?mode={0}", mode)
        My.Response.Redirect(url)
    End Sub
End Class
