Imports NetShopForge.Library.Address
Partial Class Shop_Controls_AreaControl
    Inherits System.Web.UI.UserControl

#Region "---Property----"

    Public Property AreaID() As String
        Get
            '   If IsBind Then BindData(hfAreaID.Value)
            Return hfAreaID.Value
        End Get
        Set(ByVal value As String)

            hfAreaID.Value = value
            BindData(hfAreaID.Value)
        End Set
    End Property

    Public ReadOnly Property Province() As String
        Get
      
            Return hfProvince.Value


        End Get
    End Property

    Public ReadOnly Property City() As String
        Get
         
            Return hfCity.Value


        End Get
    End Property

    Public ReadOnly Property Area() As String
        Get
  
            Return hfArea.Value


        End Get
    End Property

#End Region


    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not IsPostBack Then
            ddlProvince.Attributes.Add("onchange", "goCity();")
            ddlCity.Attributes.Add("onchange", "goArea();")
            ddlArea.Attributes.Add("onChange", "getAreaID();")
        End If
        BindData(hfAreaID.Value)
    End Sub

#Region "--Private Method---"


    Private Sub BindData(ByVal areaID As String)
        If ddlProvince.Items.Count = 0 Then LoadProvince()
        Dim provinceID, cityID As String
        If IsNothing(areaID) OrElse areaID.Length = 0 Then
            ddlProvince.SelectedIndex = 0
            LoadCity(ddlProvince.SelectedValue)
            LoadArea(ddlCity.SelectedValue)
            If ddlArea.Items.Count > 0 Then
                hfArea.Value = ddlArea.Items(0).Text
                hfAreaID.Value = ddlArea.Items(0).Value
            End If
            If ddlProvince.Items.Count > 0 Then hfProvince.Value = ddlProvince.Items(0).Text
            If ddlCity.Items.Count > 0 Then hfCity.Value = ddlCity.Items(0).Text
        Else
            provinceID = areaID.Substring(0, 2) & "0000"
            cityID = areaID.Substring(0, 4) & "00"
            ddlProvince.SelectedValue = provinceID
            hfProvince.Value = ddlProvince.SelectedItem.Text

            LoadCity(ddlProvince.SelectedValue)
            ddlCity.SelectedValue = cityID
            hfCity.Value = ddlCity.SelectedItem.Text

            LoadArea(ddlCity.SelectedValue)
            ddlArea.SelectedValue = areaID
            hfArea.Value = ddlArea.SelectedItem.Text
            hfAreaID.Value = areaID
        End If

    End Sub
    Private Sub LoadProvince()

        Dim objAC As New AreaController
        Using r As System.Data.IDataReader = objAC.GetProvinceList
            While r.Read
                ddlProvince.Items.Add(New ListItem(r("Province"), r("provinceID")))
            End While
        End Using

    End Sub
    Private Sub LoadCity(ByVal provinceID As String)
        Dim objAC As New AreaController
        Dim sCity As String = ""
        Dim citys As String() = objAC.GetCityString(provinceID).Split(",")
        Dim cityArea As String()
        ddlCity.Items.Clear()
        For Each sCity In citys
            cityArea = sCity.Split("|")
            If cityArea.Length > 1 Then
                ddlCity.Items.Add(New ListItem(cityArea(1), cityArea(0)))
            End If
        Next
    End Sub
    Private Sub LoadArea(ByVal provinceID As String)
        Dim objAC As New AreaController
        Dim sArea As String = ""
        Dim citys As String() = objAC.GetAreaString(provinceID).Split(",")
        Dim cityArea As String()
        ddlArea.Items.Clear()
        For Each sArea In citys
            cityArea = sArea.Split("|")
            If cityArea.Length > 1 Then
                ddlArea.Items.Add(New ListItem(cityArea(1), cityArea(0)))
            End If
        Next
    End Sub


#End Region
End Class
