Imports System.Data
Imports NetShopForge.Library.Category
Partial Class Shop_Categories_S
    Inherits System.Web.UI.UserControl

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not IsPostBack Then
            BindCategory()
        End If

    End Sub

    Private Sub BindCategory()

        Using dtt As DataTable = CategoryController.GetSubCategoryTable(-1)
            listTopLevelCategory.DataKeyField = "CategoryID"
            listTopLevelCategory.DataSource = dtt
            listTopLevelCategory.DataBind()
            hlCategory.Text = String.Format("ȫ{0}Ʒ", dtt.Rows.Count.ToString)
        End Using

    End Sub


   

    Protected Sub listTopLevelCategory_ItemDataBound(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.DataListItemEventArgs) Handles listTopLevelCategory.ItemDataBound
        If e.Item.ItemType = ListItemType.Item Or e.Item.ItemType = ListItemType.AlternatingItem Then
            Dim ListSubCategory As DataList = CType(e.Item.FindControl("ListSubCategory"), DataList)
            Dim id As Integer = listTopLevelCategory.DataKeys(e.Item.ItemIndex)
            Using dtt As DataTable = CategoryController.GetSubCategoryTable(id)
                ListSubCategory.DataSource = dtt
                ListSubCategory.DataBind()
            End Using
        End If
    End Sub


End Class
