Imports System.Data
Imports NetShopForge.Library.Category
Partial Class Shop_Controls_CategoryTreeControl
    Inherits System.Web.UI.UserControl
    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
    

        If Not IsPostBack Then
            hfCategoryID.Value = Request("CatID")
            If hfCategoryID.Value.Length = 0 Then
                hfCategoryID.Value = -1
            End If
            Dim cID As Integer = CInt(hfCategoryID.Value)

            If cID = -1 Then
                CategoryTitle.Text = "Ʒ"
                mvCategory.ActiveViewIndex = 0
                BindCategory()
            Else
                CategoryTitle.Text = "Ʒϸ"
                mvCategory.ActiveViewIndex = 1


                'BindSubCategory(cID)
                'lbSubCategory.Text = CategoryController.GetCategoryName(cID)
                'Dim fID As Integer = CategoryController.GetCategoryFatherID(cID)
                'If fID <> -1 Then
                '    hlFatherCategory.NavigateUrl = String.Format("~/Category.aspx?CatID={0}", fID.ToString)
                '    hlFatherCategory.Text = "[鿴һ]"
                'Else

                '    hlFatherCategory.NavigateUrl = "~/default.aspx"
                '    hlFatherCategory.Text = "[ҳ]"
                'End If


                Dim fID As Integer = CategoryController.GetCategoryFatherID(cID)
                BindCategory2(fID)
                If fID <> -1 Then
                    hlFatherCategory2.NavigateUrl = String.Format("~/Browse.aspx?CatID={0}", fID.ToString)
                    hlFatherCategory2.Text = "[鿴һ]"
                Else

                    hlFatherCategory2.NavigateUrl = "~/default.aspx"
                    hlFatherCategory2.Text = "[ҳ]"
                End If


            End If
        End If

    End Sub


    Private Sub BindCategory()

        Using dtt As DataTable = CategoryController.GetSubCategoryTable(-1)
            listTopLevelCategory.DataKeyField = "CategoryID"
            listTopLevelCategory.DataSource = dtt
            listTopLevelCategory.DataBind()
        End Using
    End Sub
    Private Sub BindCategory2(ByVal categoryID As Integer)

        Using dtt As DataTable = CategoryController.GetSubCategoryTable(categoryID)
            listTopLevelCategory2.DataKeyField = "CategoryID"
            listTopLevelCategory2.DataSource = dtt
            listTopLevelCategory2.DataBind()
        End Using
    End Sub




  

    Protected Sub listTopLevelCategory_ItemDataBound(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.DataListItemEventArgs) Handles listTopLevelCategory.ItemDataBound
        If e.Item.ItemType = ListItemType.Item Or e.Item.ItemType = ListItemType.AlternatingItem Then
            Dim ListSubCategory As DataList = CType(e.Item.FindControl("ListSubCategory"), DataList)

            Dim id As Integer = listTopLevelCategory.DataKeys(e.Item.ItemIndex)
            Using dtt As DataTable = CategoryController.GetSubCategoryTable(id)
                ListSubCategory.DataSource = dtt
                ListSubCategory.DataBind()
            End Using
        End If
    End Sub

  
    Protected Sub listTopLevelCategory2_ItemDataBound(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.DataListItemEventArgs) Handles listTopLevelCategory2.ItemDataBound
        If e.Item.ItemType = ListItemType.Item Or e.Item.ItemType = ListItemType.AlternatingItem Then

            Dim id As Integer = listTopLevelCategory2.DataKeys(e.Item.ItemIndex)
            If id = CInt(hfCategoryID.Value) Then
                Dim blSubCategory As BulletedList = CType(e.Item.FindControl("blSubCategory2"), BulletedList)
                CType(e.Item.FindControl("linkTopLevelCategory"), HyperLink).ForeColor = Drawing.Color.Orange
                Using dtt As DataTable = CategoryController.GetSubCategoryTable(id)
                    For Each r As DataRow In dtt.Rows
                        blSubCategory.Items.Add(New ListItem(r("CategoryName"), String.Format("~/Browse.aspx?CatID={0}", r("CategoryID"))))
                    Next
                End Using

            End If
            
        End If
    End Sub
End Class
