Imports AspNetSecurity = System.Web.Security
Imports NetShopForge.Library.Tracker
Partial Class Shop_Controls_LoginControl
    Inherits System.Web.UI.UserControl

    Protected Sub CreateUserWizard1_CreatedUser(ByVal sender As Object, ByVal e As System.EventArgs) Handles CreateUserWizard1.CreatedUser

        Dim UserName As String = CreateUserWizard1.UserName
        AspNetSecurity.Roles.AddUserToRole(UserName, "Customer")
    
    End Sub

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs) Handles Me.Load
        Dim redir As String = NetShopForge.Common.Utility.GetParameter("ReturnUrl")
        If (Not String.IsNullOrEmpty(redir)) Then
            CreateUserWizard1.ContinueDestinationPageUrl = redir
        End If
    End Sub


    Protected Sub NewRegistration(ByVal sender As Object, ByVal e As EventArgs)
        Dim redir As String = NetShopForge.Common.Utility.GetParameter("ReturnUrl")
        If redir <> String.Empty Then
            Response.Redirect(redir)
        Else
            Response.Redirect("~/default.aspx")
        End If
    End Sub

    Protected Sub LoginUser_LoggedIn(ByVal sender As Object, ByVal e As System.EventArgs) Handles LoginUser.LoggedIn
        If Not Request.Cookies("shopperID") Is Nothing Then
            Dim sAnonID As String = Request.Cookies("shopperID").Value
            'synch the tracker

            TrackerController.SynchTrackingCookie(LoginUser.UserName, sAnonID)

            'Log it
            TrackerController.Add(BehaviorType.LoggingIn)

            'reset the cookie so we know who this is
            Response.Cookies("shopperID").Value = LoginUser.UserName
            Response.Cookies("shopperID").Expires = DateTime.Today.AddDays(365)
        End If
    End Sub


    Protected Sub LoginUser_LoggingIn(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.LoginCancelEventArgs) Handles LoginUser.LoggingIn
        If AspNetSecurity.Roles.IsUserInRole(LoginUser.UserName, "Administrator") Then
            LoginUser.FailureText = "Բû벻ȷ룡"
            e.Cancel = True
        End If
    End Sub
End Class
