Imports NetShopForge.Library.SpecialOffer

Partial Class Shop_Controls_ShortPromoControl
    Inherits System.Web.UI.UserControl

    Public SpecialList As Generic.List(Of SpecialOfferInfo)
    Public SHORTPROMOLISTNUMBER As Integer = 5

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not IsPostBack Then
            BindData()
        End If
    End Sub

    Private Sub BindData()
        SpecialList = SpecialOfferController.GetSpecialOfferList(True, SHORTPROMOLISTNUMBER)
        dlShortPromo.DataSource = SpecialList
        dlShortPromo.DataBind()
        Me.Visible = (dlShortPromo.Items.Count > 0)
        hlAllOffer.Visible = (dlShortPromo.Items.Count > SHORTPROMOLISTNUMBER)


    End Sub


    Protected Sub dlShortPromo_ItemDataBound(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.DataListItemEventArgs) Handles dlShortPromo.ItemDataBound

        Dim hlShortPromo As HyperLink = e.Item.FindControl("hlShortPromo")

        Dim objSP As SpecialOfferInfo = SpecialList.Item(e.Item.ItemIndex)
        If objSP.ShortPromoText.Length > 0 Then
            hlShortPromo.Text = objSP.ShortPromoText
        Else
            hlShortPromo.Text = objSP.Title
        End If

        If objSP.ShortPromoImage.Length > 0 Then
            hlShortPromo.ImageUrl = "~/" & objSP.ShortPromoImage
        End If

        hlShortPromo.NavigateUrl = String.Format("xxx.aspx?offerID={0}", objSP.OfferID)


    End Sub
End Class
