#Region "Imports"

Imports NetShopForge.Library.SpeedBar
Imports System.Collections.Generic

#End Region

Partial Class Shop_Controls_SpeedBarControl
    Inherits System.Web.UI.UserControl

   

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not IsPostBack Then
            Dim listSpeedBar As List(Of SpeedBarInfo) = SpeedBarController.GetSpeedBarList
            Dim cssName As String = "nsfBlueMenu"
            SetMemu(cssName, listSpeedBar)
        End If
    End Sub


    Private Function FormatURL(ByVal url As String) As String

        If url.Length > 1 AndAlso url.Substring(0, 1) = "~" Then
            Return Page.ResolveUrl(url)
        Else
            Return url
        End If

    End Function

    Private Function SetCss(ByVal css As String) As String
        If css.Length > 0 Then
            Return String.Format("style =""{0}""", css)
        Else
            Return css
        End If
    End Function


    Private Sub SetMemu(ByVal cssName As String, ByVal sbList As List(Of SpeedBarInfo))
        Dim sb As SpeedBarInfo
        Dim s As New StringBuilder
        '<div id="nsfBlueMenu">
        '<ul>
        '<li><a href="#">Dynamic Drive</a></li>
        '</ul>
        '</div>
        s.Append(String.Format("<div id=""{0}"">", cssName))
        s.Append("<ul>")
        For Each sb In sbList

            If sb.IsValid Then s.Append(String.Format("<li ><a  href=""{0}"" title=""{2}"" {3}>{1}</a></li>", FormatURL(sb.URL), sb.Title, sb.ToolTip, SetCss(sb.CSS)))
        Next
        s.Append("</ul>")
        s.Append("</div>")
        menu.Text = s.ToString
    End Sub


End Class
